/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/otctblentry.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 1993 OTC LIMITED
//     Copyright 1994 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/collctn/tblentry.hh"
#endif

#include <OTC/collctn/tblentry.hh>

#if defined(ENV_OSTORE)
/* ------------------------------------------------------------------------- */
os_typespec* OTC_TableEntry::typespec()
{
  static os_typespec ts("OTC_TableEntry");
  return &ts;
}
#endif

/* ------------------------------------------------------------------------- */
OTC_TableEntry::~OTC_TableEntry()
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
OTC_TableEntry::OTC_TableEntry()
 : myState(OTCLIB_EMPTY), myHashValue(0), myLink(0)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
OTC_TableEntry::OTC_TableEntry(OTC_TableEntry const& theEntry)
 : myState(theEntry.myState),
   myHashValue(theEntry.myHashValue),
   myLink(theEntry.myLink)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
OTC_TableEntry::OTC_TableEntry(int theHashValue, OTC_Link* theLink)
 : myState(OTCLIB_OCCUPIED), myHashValue(theHashValue), myLink(theLink)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
OTC_TableEntry& OTC_TableEntry::operator=(OTC_TableEntry const& theEntry)
{
  myState = theEntry.myState;
  myHashValue = theEntry.myHashValue;
  myLink = theEntry.myLink;
  return *this;
}

/* ------------------------------------------------------------------------- */
