/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     debug/_assert.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
//
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//
// ============================================================================
*/

#undef NDEBUG

#include <OTC/debug/tracer.hh>
#include <OTC/OTC.h>

#include <stdlib.h>

/* ------------------------------------------------------------------------- */

// = TEST 1
//     Test failure of assertion.

void test1()
{
  OTC_Tracer tracer("void test1()");

  OTCLIB_ASSERT(OTCLIB_TRUE == OTCLIB_FALSE);

  tracer() << "XXX - Shouldn't reach here" << endl;
}

void test2()
{
  OTC_Tracer tracer("void test2()");

  OTCLIB_ASSERT_W(OTCLIB_TRUE == OTCLIB_FALSE);
}

typedef void (*testFunc)();

testFunc tests[] =
{
  test1,
  test2
};

/* ------------------------------------------------------------------------- */

main(int argc, char* argv[])
{
  u_int const numTests = sizeof(tests)/sizeof(tests[0]);

  set_terminate(otclib_terminate_function);

  if (argc != 2)
  {
    cout << numTests << endl;
    return 1;
  }
  else
  {
    int testNum = atoi(argv[1]);
    if (testNum > 0 && u_int(testNum) <= numTests)
    {
      tests[testNum-1]();
      return 0;
    }
    else
      return 1;
  }
}

/* ------------------------------------------------------------------------- */
