/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     debug/_ensure.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
//
// = COPYRIGHT
//     Copyright 1992 OTC LIMITED
//
// ============================================================================
*/

#include <OTC/debug/tracer.hh>
#include <OTC/debug/excption.hh>

#include <stdlib.h>

/* ------------------------------------------------------------------------- */

// = TEST 1
//     Test failure of precondition.

void test1()
{
  OTC_Tracer tracer("void test1()");

  OTCLIB_ENSURE((1 == 0),"1 is not equal to 0");

  tracer() << "XXX - Shouldn't reach here" << endl;
}

void test2()
{
  OTC_Tracer tracer("void test2()");

  OTCLIB_ENSURE_W((1 == 0),"1 is not equal to 0");
}

typedef void (*testFunc)();

testFunc tests[] =
{
  test1,
  test2
};

/* ------------------------------------------------------------------------- */

main(int argc, char* argv[])
{
  u_int const numTests = sizeof(tests)/sizeof(tests[0]);

  set_terminate(otclib_terminate_function);

  if (argc != 2)
  {
    cout << numTests << endl;
    return 1;
  }
  else
  {
    int testNum = atoi(argv[1]);
    if (testNum > 0 && u_int(testNum) <= numTests)
    {
      tests[testNum-1]();
      return 0;
    }
    else
      return 1;
  }
}

/* ------------------------------------------------------------------------- */
