/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     debug/_logger.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 OTC LIMITED
//
// ============================================================================
*/

#include <OTC/debug/logger.hh>
#include <OTC/debug/tracer.hh>
#include <OTC/OTC.h>

#include <stdlib.h>

/* ------------------------------------------------------------------------- */

class TST_Logger : public OTC_Logger
{
  public:

			~TST_Logger();

			TST_Logger() {}

  protected:

    void		log(
			 char const* theTarget,
			 OTC_LogLevel theLevel,
			 char const* theMessage,
			 u_int theLength
			);

  private:

			TST_Logger(TST_Logger const&);
};

TST_Logger::~TST_Logger()
{
  // Nothing to do.
}

void TST_Logger::log(
 char const*,
 OTC_LogLevel theLevel,
 char const* theMessage,
 u_int
)
{
  OTC_Tracer tracer("void TST_Logger::log()");
  tracer() << "level = " << OTCLIB_LOGLEVELMESSAGES[theLevel] << endl;
  tracer() << "message = " << theMessage << endl;
}

// = TEST 1
//     Test of output to logger with no user supplied loggers.

void test1()
{
  OTC_Tracer tracer("void test1()");

  OTC_Logger::notify(OTCLIB_LOG_EMERGENCY,"EMERGENCY level");
  OTC_Logger::notify(OTCLIB_LOG_ALERT,"ALERT level");
  OTC_Logger::notify(OTCLIB_LOG_CRITICAL,"CRITICAL level");
  OTC_Logger::notify(OTCLIB_LOG_ERROR,"ERROR level");
  OTC_Logger::notify(OTCLIB_LOG_WARNING,"WARNING level");
  OTC_Logger::notify(OTCLIB_LOG_NOTICE,"NOTICE level");
  OTC_Logger::notify(OTCLIB_LOG_INFO,"INFO level");
  OTC_Logger::notify(OTCLIB_LOG_DEBUG,"DEBUG level");
}

// = TEST 2
//     Test of output of logger with a user supplied logger.

void test2()
{
  OTC_Tracer tracer("void test2()");

  TST_Logger logger;

  OTC_Logger::notify(OTCLIB_LOG_EMERGENCY,"EMERGENCY level");
  OTC_Logger::notify(OTCLIB_LOG_ALERT,"ALERT level");
  OTC_Logger::notify(OTCLIB_LOG_CRITICAL,"CRITICAL level");
  OTC_Logger::notify(OTCLIB_LOG_ERROR,"ERROR level");
  OTC_Logger::notify(OTCLIB_LOG_WARNING,"WARNING level");
  OTC_Logger::notify(OTCLIB_LOG_NOTICE,"NOTICE level");
  OTC_Logger::notify(OTCLIB_LOG_INFO,"INFO level");
}

// = TEST 3
//     Test of output with embedded newlines.

void test3()
{
  OTC_Tracer tracer("void test3()");

  TST_Logger logger;

  OTC_Logger::notify(OTCLIB_LOG_INFO,"01234\n56789\n01234\n56789");
}

typedef void (*testFunc)();

testFunc tests[] =
{
  test1,
  test2,
  test3
};

/* ------------------------------------------------------------------------- */

main(int argc, char* argv[])
{
  u_int const numTests = sizeof(tests)/sizeof(tests[0]);

  set_terminate(otclib_terminate_function);

  if (argc != 2)
  {
    cout << numTests << endl;
    return 1;
  }
  else
  {
    int testNum = atoi(argv[1]);
    if (testNum > 0 && u_int(testNum) <= numTests)
    {
      tests[testNum-1]();
      return 0;
    }
    else
      return 1;
  }
}

/* ------------------------------------------------------------------------- */
