/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     debug/otcasrtfail.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 OTC LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/debug/asrtfail.hh"
#endif

#include <OTC/debug/asrtfail.hh>

#include <iostream.h>

/* ------------------------------------------------------------------------- */
OTCERR_AssertionFailure::OTCERR_AssertionFailure(
 char const* theFile,
 u_int theLine,
 char const* theCondition
)
  : OTC_Exception("Assertion failed",theFile,theLine),
    myCondition(theCondition)
{
  if (myCondition == 0)
    myCondition = "";
}

/* ------------------------------------------------------------------------- */
OTCERR_AssertionFailure::OTCERR_AssertionFailure(
 OTCERR_AssertionFailure const& theException
)
  : OTC_Exception(theException),
    myCondition(theException.myCondition)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
OTCERR_AssertionFailure::~OTCERR_AssertionFailure()
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
void OTCERR_AssertionFailure::display(ostream& outs) const
{
  OTC_Exception::display(outs);

  outs << "Condition: " << myCondition << endl;
}

/* ------------------------------------------------------------------------- */
