/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     debug/otcexcption.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 OTC LIMITED
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/debug/excption.hh"
#endif

#include <OTC/debug/excption.hh>
#include <OTC/debug/logstrm.hh>

#include <iostream.h>
#include <stdlib.h>

/* ------------------------------------------------------------------------- */
OTC_NRMutex OTC_Exception::_mutex;
OTC_ThrowFunction OTC_Exception::globThrowFunction = 0;
OTC_Boolean OTC_Exception::globInitialised = OTCLIB_FALSE;
OTC_Boolean OTC_Exception::globLogException = OTCLIB_FALSE;

/* ------------------------------------------------------------------------- */
OTC_Exception::OTC_Exception(char const* theError)
  : myError(theError), myFile(0), myLine(0)
{
  if (myError == 0)
    myError = "Unknown error";
}

/* ------------------------------------------------------------------------- */
OTC_Exception::OTC_Exception(
 char const* theError,
 char const* theFile,
 u_int theLine
)
  : myError(theError), myFile(theFile), myLine(theLine)
{
  if (myError == 0)
    myError = "Unknown error";
}

/* ------------------------------------------------------------------------- */
OTC_Exception::OTC_Exception(OTC_Exception const& theException)
  : myError(theException.myError),
    myFile(theException.myFile),
    myLine(theException.myLine)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
OTC_Exception::~OTC_Exception()
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
void OTC_Exception::display(ostream& outs) const
{
  outs << myError << endl;

  if (myFile != 0)
    outs << "Location: " << myFile << ", line " << myLine << endl;
}

/* ------------------------------------------------------------------------- */
void OTC_Exception::throwException(OTC_Exception& theException)
{
  OTC_ThrowFunction theFunction;
  OTC_Boolean theLogException;

  _mutex.lock();

  if (globInitialised == OTCLIB_FALSE)
  {
    globInitialised = OTCLIB_TRUE;

    char const* theVariable;
    theVariable = getenv("OTCLIB_LOGEXCEPTION");
    if (theVariable != 0)
      globLogException = OTCLIB_TRUE;
  }

  theFunction = globThrowFunction;

#if defined(HAVE_EXCEPTIONS) && !defined(ENV_NOTHROWEXCEPTION)
  theLogException = globLogException;
#else
  theLogException = OTCLIB_TRUE;
#endif

  _mutex.unlock();

  if (theFunction)
    theFunction(theException);

  if (theLogException != OTCLIB_FALSE)
  {
    char buf[2048];
    OTC_LogStream outs(buf,sizeof(buf));
    outs.setLevel(OTCLIB_LOG_ERROR);
    theException.display(outs);
  }

#if defined(HAVE_EXCEPTIONS) && !defined(ENV_NOTHROWEXCEPTION)
  throw theException;
#else
  terminate();
#endif
}

/* ------------------------------------------------------------------------- */
OTC_ThrowFunction OTC_Exception::setThrow(OTC_ThrowFunction theFunction)
{
  OTC_ThrowFunction oldFunction;

  _mutex.lock();

  oldFunction = globThrowFunction;
  globThrowFunction = theFunction;

  _mutex.unlock();

  return oldFunction;
}

/* ------------------------------------------------------------------------- */
