/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     debug/otclogbuf.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 OTC LIMITED
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/debug/logbuf.hh"
#endif

#include <OTC/debug/logbuf.hh>

#ifndef zapeof
#define zapeof(c) ((c)&0377)
#endif

/* ------------------------------------------------------------------------- */
OTC_LogBuf::~OTC_LogBuf()
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
OTC_LogBuf::OTC_LogBuf(char* theBuffer, int theSize)
  : myTarget(0), myLevel(OTCLIB_LOG_DEBUG)
{
  setbuf(theBuffer,theSize);
  setp(base(),ebuf());
}

/* ------------------------------------------------------------------------- */
streambuf* OTC_LogBuf::setbuf(char* theBuffer, int theSize)
{
  if (base())
    return 0;

  if (theBuffer != 0 && theSize > (int)sizeof(myBuffer))
    setb(theBuffer,theBuffer+theSize-2);
  else
    setb(myBuffer,myBuffer+sizeof(myBuffer)-2);

  setp(0,0);
  setg(0,0,0);

  return this;
}

/* ------------------------------------------------------------------------- */
int OTC_LogBuf::overflow(int c)
{
  char* endp = pptr();

  *endp = EOS;
  *(endp+1) = EOS;

  while (*(endp-1) == '\n' && endp > pbase())
    *--endp = EOS;

  if (c != EOF && c != EOS)
    *endp++ = c;

  OTC_Logger::notify(myTarget,myLevel,pbase(),endp-pbase());

  setp(base(),ebuf());
  return zapeof(c);
}

/* ------------------------------------------------------------------------- */
int OTC_LogBuf::underflow()
{
  return 0;
}

/* ------------------------------------------------------------------------- */
int OTC_LogBuf::sync()
{
  if (pptr() && pptr() > pbase())
  {
    // LIBG++ does check explicitly for -1, so must make sure
    // we return 0 if all is okay.

    int c = overflow(EOF);
    return c == -1 ? -1 : 0;
  }

  return 0;
}

/* ------------------------------------------------------------------------- */
