/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     debug/otcprecfail.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 OTC LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/debug/precfail.hh"
#endif

#include <OTC/debug/precfail.hh>

#include <iostream.h>

/* ------------------------------------------------------------------------- */
OTCERR_PreconditionFailure::OTCERR_PreconditionFailure(
 char const* theFile,
 u_int theLine,
 char const* theCondition,
 char const* theDescription
)
  : OTC_Exception("Precondition failed",theFile,theLine),
    myCondition(theCondition),
    myDescription(theDescription)
{
  if (myCondition == 0)
    myCondition = "";
  if (myDescription == 0)
    myDescription = "";
}

/* ------------------------------------------------------------------------- */
OTCERR_PreconditionFailure::OTCERR_PreconditionFailure(
 OTCERR_PreconditionFailure const& theException
)
  : OTC_Exception(theException),
    myCondition(theException.myCondition),
    myDescription(theException.myDescription)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
OTCERR_PreconditionFailure::~OTCERR_PreconditionFailure()
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
void OTCERR_PreconditionFailure::display(ostream& outs) const
{
  OTC_Exception::display(outs);

  outs << "Condition: " << myCondition << endl;
  outs << "Description: " << myDescription << endl;
}

/* ------------------------------------------------------------------------- */
