/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     debug/otctobject.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
//
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/debug/tobject.hh"
#endif

#include <OTC/debug/tobject.hh>

/* ------------------------------------------------------------------------- */
OTC_NRMutex OTC_TObject::_mutex;
OTC_TObject* OTC_TObject::myHead = 0;

/* ------------------------------------------------------------------------- */
OTC_TObject::~OTC_TObject()
{
  unlink();
}

/* ------------------------------------------------------------------------- */
OTC_TObject::OTC_TObject()
 : myNext(0), myPrev(0)
{
  link();
}

/* ------------------------------------------------------------------------- */
void OTC_TObject::terminateAll()
{
  _mutex.lock();

  if (myHead)
  {
    while (myHead)
    {
      myHead->cleanup();
      myHead = myHead->myNext;
    }
  }

  _mutex.unlock();
}

/* ------------------------------------------------------------------------- */
void OTC_TObject::link()
{
  _mutex.lock();

  if (!myHead)
  {
    myHead = this;
  }
  else
  {
    myNext = myHead;
    myNext->myPrev = this;
    myHead = this;
  }

  _mutex.unlock();
}

/* ------------------------------------------------------------------------- */
void OTC_TObject::unlink()
{
  _mutex.lock();

  if (myHead == this)
  {
    myHead = myNext;
  }
  else
  {
    myPrev->myNext = myNext;
    if (myNext)
      myNext->myPrev = myPrev;
  }

  _mutex.unlock();
}

/* ------------------------------------------------------------------------- */
