/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     debug/otctracetag.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 TELSTRA CORPORATION LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/debug/tracetag.hh"
#endif

#include <OTC/debug/tracetag.hh>

#include <stdlib.h>
#include <string.h>
#include <strstream.h>

/* ------------------------------------------------------------------------- */
OTC_NRMutex OTC_TraceTag::_mutex;
char* OTC_TraceTag::globTagVariable = 0;
OTC_TagInfo* OTC_TraceTag::globTagInfo = 0;

/* ------------------------------------------------------------------------- */
#if !defined(__OSE_TEMPLATES__) && !defined(CXX_OS)
OTC_TraceTag::~OTC_TraceTag()
{
  // Nothing to do.
}
#endif

/* ------------------------------------------------------------------------- */
OTC_TraceTag::OTC_TraceTag(char const* theName)
  : myTagInfo(0)
{
  OTCLIB_ENSURE((theName != 0),
   "OTC_TraceTag::OTC_TraceTag() - invalid tag name");

  _mutex.lock();

  OTC_TagInfo* theInfo;

  if (globTagVariable == 0)
  {
    globTagVariable = getenv("OTCLIB_TRACETAGS");
    if (globTagVariable == 0)
      globTagVariable = "";

    if (*globTagVariable != 0)
    {
      istrstream ins(globTagVariable);
      char buf[64];
      while (ins.good())
      {
	char* theIndex = 0;
	int theLevel = 0;

	ins >> ws;
	ins.width(64);
	ins >> buf;

	if (!ins.fail())
	{
	  theIndex = strchr(buf,'=');
	  if (theIndex != 0)
	  {
	    *theIndex = EOS;
	    theLevel = atoi(theIndex+1);
	  }

	  char* tmpString = new char[strlen(buf)+1];
	  OTCLIB_ASSERT(tmpString != 0);
	  strcpy(tmpString,buf);

	  theInfo = new OTC_TagInfo(tmpString,theLevel,globTagInfo);
	  OTCLIB_ASSERT(theInfo != 0);

	  globTagInfo = theInfo;
	}
      }
    }
  }

  theInfo = globTagInfo;
  while (theInfo != 0)
  {
    if (strcmp(theInfo->name(),theName) == 0)
    {
      myTagInfo = theInfo;
      break;
    }
    theInfo = theInfo->next();
  }

  if (myTagInfo == 0)
  {
    char* tmpString = new char[strlen(theName)+1];
    OTCLIB_ASSERT(tmpString != 0);
    strcpy(tmpString,theName);

    theInfo = new OTC_TagInfo(tmpString,-1,globTagInfo);
    OTCLIB_ASSERT(theInfo != 0);

    globTagInfo = theInfo;
    myTagInfo = theInfo;
  }

  _mutex.unlock();
}

/* ------------------------------------------------------------------------- */
OTC_Boolean OTC_TraceTag::enabled() const
{
  return (myTagInfo->level() >= 0) ? OTCLIB_TRUE : OTCLIB_FALSE;
}

/* ------------------------------------------------------------------------- */
int OTC_TraceTag::set(char const* theName, int theLevel)
{
  OTC_TagInfo* theInfo;
  int oldLevel = -1;

  _mutex.lock();

  theInfo = globTagInfo;
  while (theInfo != 0)
  {
    if (strcmp(theInfo->name(),theName) == 0)
    {
      oldLevel = theInfo->level();
      theInfo->setLevel(theLevel);
      break;
    }
    theInfo = theInfo->next();
  }

  if (theInfo == 0)
  {
    char* tmpString = new char[strlen(theName)+1];
    OTCLIB_ASSERT(tmpString != 0);
    strcpy(tmpString,theName);

    theInfo = new OTC_TagInfo(tmpString,theLevel,globTagInfo);
    OTCLIB_ASSERT(theInfo != 0);

    globTagInfo = theInfo;
  }

  _mutex.unlock();

  return oldLevel;
}

/* ------------------------------------------------------------------------- */
OTC_TraceSwitch OTC_TraceTag::operator==(int theLevel) const
{
  return ((level() >= 0) && (level() == theLevel)) ? OTCLIB_TRUE : OTCLIB_FALSE;
}

/* ------------------------------------------------------------------------- */
OTC_TraceSwitch OTC_TraceTag::operator!=(int theLevel) const
{
  return ((level() >= 0) && (level() != theLevel)) ? OTCLIB_TRUE : OTCLIB_FALSE;
}

/* ------------------------------------------------------------------------- */
OTC_TraceSwitch OTC_TraceTag::operator<(int theLevel) const
{
  return ((level() >= 0) && (level() < theLevel)) ? OTCLIB_TRUE : OTCLIB_FALSE;
}

/* ------------------------------------------------------------------------- */
OTC_TraceSwitch OTC_TraceTag::operator<=(int theLevel) const
{
  return ((level() >= 0) && (level() <= theLevel)) ? OTCLIB_TRUE : OTCLIB_FALSE;
}

/* ------------------------------------------------------------------------- */
OTC_TraceSwitch OTC_TraceTag::operator>(int theLevel) const
{
  return ((level() >= 0) && (level() > theLevel)) ? OTCLIB_TRUE : OTCLIB_FALSE;
}

/* ------------------------------------------------------------------------- */
OTC_TraceSwitch OTC_TraceTag::operator>=(int theLevel) const
{
  return ((level() >= 0) && (level() >= theLevel)) ? OTCLIB_TRUE : OTCLIB_FALSE;
}

/* ------------------------------------------------------------------------- */
