/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     debug/otctrcebuf.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1994 TELSTRA CORPORATION LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/debug/trcebuf.hh"
#endif

#include <OTC/debug/trcebuf.hh>
#include <OTC/debug/trcestrm.hh>
#include <OTC/debug/tracer.hh>

#include <string.h>

/* ------------------------------------------------------------------------- */
OTC_TraceBuf::~OTC_TraceBuf()
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
OTC_TraceBuf::OTC_TraceBuf(OTC_TraceStream* theStream)
  : myStream(theStream), myStartOfLine(OTCLIB_TRUE)
{
  OTCLIB_ASSERT(theStream != 0);

  setbuf(myBuffer,sizeof(myBuffer));
  setp(base(),ebuf());
}

/* ------------------------------------------------------------------------- */
streambuf* OTC_TraceBuf::setbuf(char* theBuffer, int theSize)
{
  if (base())
    return 0;

  if (theBuffer != 0 && theSize > (int)sizeof(myBuffer))
    setb(theBuffer,theBuffer+theSize-1);
  else
    setb(myBuffer,myBuffer+sizeof(myBuffer)-1);

  setp(0,0);
  setg(0,0,0);

  return this;
}

/* ------------------------------------------------------------------------- */
int OTC_TraceBuf::sync()
{
  if (pptr() && pptr() > pbase())
  {
    int c = overflow(EOF);
    return c == -1 ? -1 : 0;
  }

  return 0;
}

/* ------------------------------------------------------------------------- */
int OTC_TraceBuf::overflow(int c)
{
  char* endp = pptr();

  if (c != EOF)
  {
    *endp = c;
    endp++;
  }

  char* startl = pbase();
  char* p = startl;

  ostream* outs = OTC_Tracer::stream();
  if (outs == 0)
    outs = &clog;

  while (p != endp)
  {
    while (p != endp && *p != EOL)
      p++;

    if (myStartOfLine != OTCLIB_FALSE)
    {
      if (OTC_Tracer::traceIndent() != OTCLIB_FALSE)
      {
	for (long i = myStream->level(); i>0; i--)
	  outs->rdbuf()->sputc(' ');
      }
    }

    if (p == endp)
      outs->rdbuf()->sputn(startl,p-startl);
    else
      outs->rdbuf()->sputn(startl,p-startl+1);

    outs->rdbuf()->sync();

    startl = p+1;

    if (p != endp)
    {
      if (*p == EOL)
	myStartOfLine = OTCLIB_TRUE;
      else
	myStartOfLine = OTCLIB_FALSE;
      p++;
    }
    else
      myStartOfLine = OTCLIB_FALSE;
  }

  setp(base(),ebuf());
  return 0;
}

/* ------------------------------------------------------------------------- */
int OTC_TraceBuf::underflow()
{
  return 0;
}

/* ------------------------------------------------------------------------- */
