/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     debug/otctrcestrm.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1994 TELSTRA CORPORATION LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/debug/trcestrm.hh"
#endif

#include <OTC/debug/trcestrm.hh>
#include <OTC/debug/trcebuf.hh>
#include <OTC/debug/tracer.hh>

/* ------------------------------------------------------------------------- */
OTC_Boolean OTC_TraceStream::myInitialised = OTCLIB_FALSE;
int OTC_TraceStream::myObjectIndex = 0;
int OTC_TraceStream::myLevelIndex = 0;

/* ------------------------------------------------------------------------- */
OTC_TraceStream::~OTC_TraceStream()
{
  delete myBuf;
}

/* ------------------------------------------------------------------------- */
OTC_TraceStream::OTC_TraceStream()
{
  if (myInitialised == OTCLIB_FALSE)
  {
    myInitialised = OTCLIB_TRUE;

    // Allocate space in parameter pool. Each instance has its own
    // set of parameters.

    myObjectIndex = ios::xalloc();
    myLevelIndex = ios::xalloc();
  }

  // Other initialisation. For example, creation of our streambuf,
  // also have to pass pointer of this to our streambuf so it can
  // access parameters.

  myBuf = new OTC_TraceBuf(this);
  OTCLIB_ASSERT(myBuf != 0);

  init(myBuf);

  // Make sure ours are allocated and also initialised.

  pword(myObjectIndex) = (ostream*)this;
  iword(myLevelIndex) = 0;
}

/* ------------------------------------------------------------------------- */
long OTC_TraceStream::level()
{
  return iword(myLevelIndex);
}

/* ------------------------------------------------------------------------- */
ostream& OTCLIB_TRACEIN(ostream& os)
{
  if (OTC_TraceStream::myInitialised == OTCLIB_FALSE)
    return os;

  // Sanity check.

  if (os.pword(OTC_TraceStream::myObjectIndex) != &os)
    return os;

  // Flush it in case we have output an embedded EOL which hasn't
  // been processed yet.

  os.flush();

  // Increment index.

  long& theIndentLevel = os.iword(OTC_TraceStream::myLevelIndex);
  theIndentLevel++;

  return os;
}

/* ------------------------------------------------------------------------- */
ostream& OTCLIB_TRACEOUT(ostream& os)
{
  if (OTC_TraceStream::myInitialised == OTCLIB_FALSE)
    return os;

  // Sanity check.

  if (os.pword(OTC_TraceStream::myObjectIndex) != &os)
    return os;

  // Flush it in case we have output an embedded EOL which hasn't
  // been processed yet.

  os.flush();

  // Decrement index.

  long& theIndentLevel = os.iword(OTC_TraceStream::myLevelIndex);
  OTCLIB_ASSERT(theIndentLevel > 0);
  if (theIndentLevel > 0)
    theIndentLevel--;

  return os;
}

/* ------------------------------------------------------------------------- */
