/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     debug/otctrcswtch.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 TELSTRA CORPORATION LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/debug/trcswtch.hh"
#endif

#include <OTC/debug/trcswtch.hh>

/* ------------------------------------------------------------------------- */
#if !defined(__OSE_TEMPLATES__) && !defined(CXX_OS)
OTC_TraceSwitch::~OTC_TraceSwitch()
{
  // Nothing to do.
}
#endif

/* ------------------------------------------------------------------------- */
OTC_Boolean OTC_TraceSwitch::enabled() const
{
  return myState;
}

/* ------------------------------------------------------------------------- */
OTC_TraceSwitch::operator int() const
{
  return enabled() ? 0 : -1;
}

/* ------------------------------------------------------------------------- */
OTC_TraceSwitch OTC_TraceSwitch::operator||(
 OTC_TraceSwitch const& theSwitch
) const
{
  return (enabled() || theSwitch.enabled()) ? OTCLIB_TRUE : OTCLIB_FALSE;
}

/* ------------------------------------------------------------------------- */
OTC_TraceSwitch OTC_TraceSwitch::operator&&(
 OTC_TraceSwitch const& theSwitch
) const
{
  return (enabled() && theSwitch.enabled()) ? OTCLIB_TRUE : OTCLIB_FALSE;
}

/* ------------------------------------------------------------------------- */
OTC_TraceSwitch OTC_TraceSwitch::operator!() const
{
  return enabled() ? OTCLIB_FALSE : OTCLIB_TRUE;
}

/* ------------------------------------------------------------------------- */
