/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     dispatch/_dispatch.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 OTC LIMITED
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/dispatch/evagent.hh>
#include <OTC/dispatch/event.hh>
#include <OTC/dispatch/dispatch.hh>

#include <OUX/program/program.hh>
#include <OTC/debug/tracer.hh>
#include <OTC/debug/logstrm.hh>

#include <stdlib.h>
#include <signal.h>
#if defined(HAVE_UNISTD_H)
#include <unistd.h>
#endif

#ifdef _MSC_VER
#include <windows.h>
inline void sleep(int period) { Sleep(period*1000); }
#endif

/* ------------------------------------------------------------------------- */

class Event1 : public OTC_Event
{
  public:

    void		dump(ostream& outs) const;

    void*		type() const;

    static void*	typeId()
				{ return &globTypeId; }

  private:

    static int		globTypeId;
};

int Event1::globTypeId = 0;

void Event1::dump(ostream& outs) const
{
  outs << "<Event1>";
}

void* Event1::type() const
{
  return typeId();
}

class Event2 : public OTC_Event
{
  public:

    void		dump(ostream& outs) const;

    void*		type() const;

    static void*	typeId()
				{ return &globTypeId; }

  private:

    static int		globTypeId;
};

int Event2::globTypeId = 0;

void Event2::dump(ostream& outs) const
{
  outs << "<Event2>";
}

void* Event2::type() const
{
  return typeId();
}

class Agent1 : public OTC_EVAgent
{
  public:

			Agent1()
			  : myCount(0)
				{}

  protected:

    void		handle(OTC_Event* theEvent);

  private:

    int			myCount;
};

void Agent1::handle(OTC_Event* theEvent)
{
  OTC_Tracer tracer("Agent1::handle()");

  ostream& outs = tracer();
  theEvent->dump(outs);
  outs << endl;

  if (theEvent->type() == Event2::typeId())
  {
    theEvent->queue(id());
    tracer() << "start sleep" << endl;
    sleep(3);
    tracer() << "end sleep" << endl;
  }
  else
    theEvent->destroy();
}

Agent1* theAgent = 0;

main(int argc, char* argv[])
{
  set_terminate(otclib_terminate_function);

  OUX_Program::initialise(argc,argv);

  OTC_Dispatcher::initialise();

  OTC_Event* theEvent;

  theAgent = new Agent1;

  theEvent = new Event1;
  theEvent->deliver(theAgent);

  theEvent = new Event1;
  theEvent->queue(theAgent->id());

  theEvent = new Event2;
  theEvent->queue(theAgent->id());

  theEvent = new Event1;
  theEvent->queue(theAgent->id());

  theEvent = new Event2;
  theEvent->queue(theAgent->id());

  Agent1* theAgents[100];

  u_int i;

  for (i=0; i<100; i++)
    theAgents[i] = new Agent1;

  for (i=0; i<100; i++)
    delete theAgents[i];

  for (i=0; i<100; i++)
    theAgents[i] = new Agent1;

  OTC_Dispatcher::run();

  delete theAgent;

  return 0;
}

/* ------------------------------------------------------------------------- */
