/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     dispatch/otcaction.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/dispatch/action.hh"
#endif

#include <OTC/dispatch/action.hh>
#include <OTC/dispatch/job.hh>
#include <OTC/dispatch/dispatch.hh>
#include <OTC/collctn/linklist.hh>
#include <iostream.h>

/* ------------------------------------------------------------------------- */
class OTC_ActionSubscription : public OTC_Link
{
  public:

			OTC_ActionSubscription(int theAgentId, int theActionId)
			  : myAgentId(theAgentId),
			    myActionId(theActionId),
			    myActive(OTCLIB_TRUE)
				{}

			~OTC_ActionSubscription();

    int			agent() const
				{ return myAgentId; }

    int			action() const
				{ return myActionId; }

    OTC_Boolean		active() const
				{ return myActive; }

    void		cancel()
				{ myActive = OTCLIB_FALSE; }

  private:

    int			myAgentId;

    int			myActionId;

    OTC_Boolean		myActive;
};

OTC_ActionSubscription::~OTC_ActionSubscription()
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
class OTC_ActionJob : public OTC_Job
{
  public:

			OTC_ActionJob(OTC_ActionSubscription* theSubscription)
			  : mySubscription(theSubscription) {}

			~OTC_ActionJob();

  protected:

    void		execute();

  private:

    OTC_ActionSubscription*	mySubscription;
};

OTC_ActionJob::~OTC_ActionJob()
{
  if (mySubscription != 0)
    mySubscription->kill();
}

void OTC_ActionJob::execute()
{
  OTCLIB_ASSERT(mySubscription != 0);

  if (mySubscription->active())
  {
    OTCEV_Action* theEvent;
    theEvent = new OTCEV_Action(mySubscription->action());
    OTCLIB_ASSERT(theEvent != 0);

    theEvent->deliver(mySubscription->agent());
  }

  mySubscription->kill();
  mySubscription = 0;
}

/* ------------------------------------------------------------------------- */
OTC_NRMutex OTCEV_Action::_mutex;
OTC_LinkList* OTCEV_Action::globSubscriptions = 0;
int OTCEV_Action::globTypeId = 0;
int OTCEV_Action::globActionIdCount = 0;

/* ------------------------------------------------------------------------- */
OTCEV_Action::~OTCEV_Action()
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
void* OTCEV_Action::type() const
{
  return typeId();
}

/* ------------------------------------------------------------------------- */
void OTCEV_Action::dump(ostream& outs) const
{
  outs << "<OTC> ACTION - action = " << action();
}

/* ------------------------------------------------------------------------- */
int OTCEV_Action::schedule(int theAgentId, int theOptions)
{
  OTCLIB_ENSURE((theAgentId != 0),
   "OTCEV_Action::schedule() - invalid agent ID");

  _mutex.lock();

  if (globSubscriptions == 0)
  {
    globSubscriptions = new OTC_LinkList;
    OTCLIB_ASSERT(globSubscriptions != 0);
  }

  globActionIdCount++;
  if (globActionIdCount == 0)
    globActionIdCount++;

  OTC_ActionSubscription* theSubscription;
  theSubscription = new OTC_ActionSubscription(theAgentId,globActionIdCount);
  OTCLIB_ASSERT(theSubscription != 0);
  globSubscriptions->addLast(theSubscription);

  OTC_ActionJob* theJob;
  theJob = new OTC_ActionJob(theSubscription);
  OTCLIB_ASSERT(theJob != 0);

  OTC_Dispatcher::schedule(theJob,theOptions);

  int theCount;
  theCount = globActionIdCount;

  _mutex.unlock();

  return theCount;
}

/* ------------------------------------------------------------------------- */
void OTCEV_Action::cancel(int theActionId)
{
  _mutex.lock();

  if (globSubscriptions != 0)
  {
    OTC_LinkIterator items = globSubscriptions->items();
    for (items.next(); !items.isEnd(); items.next())
    {
      OTC_ActionSubscription* theSubscription;
      theSubscription = (OTC_ActionSubscription*)items.link();
      if (theSubscription->action() == theActionId)
      {
	theSubscription->cancel();
	break;
      }
    }
  }

  _mutex.unlock();
}

/* ------------------------------------------------------------------------- */
void OTCEV_Action::cancelAgent(int theAgentId)
{
  _mutex.lock();

  if (globSubscriptions != 0)
  {
    OTC_LinkIterator items = globSubscriptions->items();
    for (items.next(); !items.isEnd(); items.next())
    {
      OTC_ActionSubscription* theSubscription;
      theSubscription = (OTC_ActionSubscription*)items.link();
      if (theSubscription->agent() == theAgentId)
	theSubscription->cancel();
    }
  }

  _mutex.unlock();
}

/* ------------------------------------------------------------------------- */
OTC_Boolean OTCEV_Action::active(int theActionId)
{
  OTC_Boolean theStatus;
  theStatus = OTCLIB_FALSE;

  _mutex.lock();

  OTC_ActionSubscription* theSubscription = 0;

  if (globSubscriptions != 0)
  {
    OTC_LinkIterator items = globSubscriptions->items();
    for (items.next(); theStatus==OTCLIB_FALSE && !items.isEnd(); items.next())
    {
      theSubscription = (OTC_ActionSubscription*)items.link();
      if (theSubscription->action() == theActionId)
	theStatus = OTCLIB_TRUE;
    }
  }

  if (theStatus != OTCLIB_FALSE)
    theStatus = theSubscription->active();

  _mutex.unlock();

  return theStatus;
}

/* ------------------------------------------------------------------------- */
