/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     dispatch/otcdispatch.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 OTC LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/dispatch/dispatch.hh"
#endif

#include <OTC/dispatch/dispatch.hh>

/* ------------------------------------------------------------------------- */
OTC_NRMutex OTC_Dispatcher::_mutex;
void (*OTC_Dispatcher::globFunc)() = 0;
OTC_JobQueue* OTC_Dispatcher::globJobQueue = 0;
OTC_DispatcherState OTC_Dispatcher::globState = OTCLIB_WAITING;

/* ------------------------------------------------------------------------- */
void OTC_Dispatcher::initialise()
{
  OTC_JobQueue* theJobQueue;
  theJobQueue = new OTC_JobQueue;
  OTCLIB_ASSERT(theJobQueue != 0);
  initialise(theJobQueue);
}

/* ------------------------------------------------------------------------- */
void OTC_Dispatcher::initialise(
 OTC_JobQueue* theJobQueue,
 void (*theFunc)()
)
{
  OTCLIB_ENSURE((queue() == 0),
   "OTC_Dispatcher::initialise() - dispatcher already initialised");
  OTCLIB_ENSURE((theJobQueue != 0),
   "OTC_Dispatcher::initialise() - invalid jobqueue");

  _mutex.lock();

  globJobQueue = theJobQueue;
  globFunc = theFunc;

  _mutex.unlock();
}

/* ------------------------------------------------------------------------- */
OTC_JobQueue* OTC_Dispatcher::queue()
{
  OTC_JobQueue* theJobQueue;

  _mutex.lock();

  theJobQueue = globJobQueue;

  _mutex.unlock();

  return theJobQueue;
}

/* ------------------------------------------------------------------------- */
int OTC_Dispatcher::dispatch(int theActions, int theOptions)
{
  OTCLIB_ENSURE((queue() != 0),
   "OTC_Dispatcher::run() - dispatcher not initialised");

  int theResult;
  theResult = 0;

  OTC_Job* theJob;
  theJob = 0;

  _mutex.lock();

  if (globState == OTCLIB_STOPPED)
  {
    theResult = -1;
  }
  else
  {
    globState = OTCLIB_RUNNING;

    if (globFunc)
      globFunc();

    // Check state again in case user supplied function stopped
    // the dispatcher.

    if (globState == OTCLIB_STOPPED)
    {
      theResult = -1;
    }
    else
    {
      theJob = globJobQueue->next(theActions,theOptions);

      if (theJob == 0 && theActions == 0)
	globState = OTCLIB_STOPPED;
    }
  }

  _mutex.unlock();

  if (theJob != 0)
  {
    theJob->execute();
    theJob->destroy();
    theResult = 1;
  }

  return theResult;
}

/* ------------------------------------------------------------------------- */
int OTC_Dispatcher::run()
{
  int theResult = 1;

  while (theResult > 0)
    theResult = dispatch(); 

  return theResult;
}

/* ------------------------------------------------------------------------- */
void OTC_Dispatcher::stop()
{
  _mutex.lock();

  globState = OTCLIB_STOPPED;

  _mutex.unlock();
}

/* ------------------------------------------------------------------------- */
void OTC_Dispatcher::reset()
{
  OTCLIB_ENSURE((isStopped()),
   "OTC_Dispatcher::reset() - not in stopped state");

  _mutex.lock();

  globState = OTCLIB_WAITING;

  _mutex.unlock();
}

/* ------------------------------------------------------------------------- */
OTC_Boolean OTC_Dispatcher::isWaiting()
{
  OTC_Boolean theResult;

  _mutex.lock();

  theResult = globState == OTCLIB_WAITING;

  _mutex.unlock();

  return theResult;
}

/* ------------------------------------------------------------------------- */
OTC_Boolean OTC_Dispatcher::isRunning()
{
  OTC_Boolean theResult;

  _mutex.lock();

  theResult = globState == OTCLIB_RUNNING;

  _mutex.unlock();

  return theResult;
}

/* ------------------------------------------------------------------------- */
OTC_Boolean OTC_Dispatcher::isStopped()
{
  OTC_Boolean theResult;

  _mutex.lock();

  theResult = globState == OTCLIB_STOPPED;

  _mutex.unlock();

  return theResult;
}

/* ------------------------------------------------------------------------- */
void OTC_Dispatcher::schedule(OTC_Job* theJob, int theOptions)
{
  OTCLIB_ENSURE((queue() != 0),
   "OTC_Dispatcher::run() - dispatcher not initialised");

  _mutex.lock();

  globJobQueue->add(theJob,theOptions);

  _mutex.unlock();
}

/* ------------------------------------------------------------------------- */
