/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     dispatch/otcevagent.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 OTC LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/dispatch/evagent.hh"
#endif

#include <OTC/dispatch/evagent.hh>
#include <OTC/dispatch/dispatch.hh>

/* ------------------------------------------------------------------------- */
OTC_NRMutex OTC_EVAgent::_mutex;
OTC_AVLTree* OTC_EVAgent::globAgents = 0;
int OTC_EVAgent::globId = 0;

/* ------------------------------------------------------------------------- */
OTC_EVAgent::~OTC_EVAgent()
{
  _mutex.lock();

  // Need to make sure we unlink ourselves from
  // the tree tracking all agents before
  // destructor is called, else an exception
  // will be raised when the base class realises
  // it is still linked into a tree.

  unlink();

  _mutex.unlock();
}

/* ------------------------------------------------------------------------- */
OTC_EVAgent* OTC_EVAgent::lookup(int theAgentId)
{
  OTC_EVAgent* theAgent;
  theAgent = 0;

  _mutex.lock();

  if (globAgents != 0)
  {
    int theRank;
    OTC_AVLNode* theNode;

    theNode = globAgents->root();
    while (theAgent == 0 && theNode != 0)
    {
      theRank = theAgentId - ((OTC_EVAgent*)theNode)->id();

      if (theRank == 0)
	theAgent = (OTC_EVAgent*)theNode;
      else if (theRank < 0)
	theNode = theNode->left();
      else
	theNode = theNode->right();
    }
  }

  _mutex.unlock();

  return theAgent;
}

/* ------------------------------------------------------------------------- */
OTC_EVAgent::OTC_EVAgent()
{
  _mutex.lock();

  if (globAgents == 0)
  {
    globAgents = new OTC_AVLTree;
    OTCLIB_ASSERT(globAgents != 0);
  }

  myId = globId++;

  // It is unlikely it will wrap around, but
  // just in case. Also, never use id 0, use
  // this for a bad agent.

  if (myId == 0)
    myId++;

  int theRank = 0;
  OTC_AVLNode* theNode;
  OTC_AVLNode* theParent;

  theNode = globAgents->root();

  if (theNode != 0)
  {
    while (theRank == 0)
    {
      theNode = globAgents->root();
      theParent = 0;

      while (theNode != 0)
      {
	theParent = theNode;
	theRank = myId - ((OTC_EVAgent*)theNode)->id();

	if (theRank == 0)
	  break;
	else if (theRank < 0)
	  theNode = theNode->left();
	else
	  theNode = theNode->right();
      }

      if (theRank == 0)
	myId = globId++;
      else if (theRank < 0)
	theParent->addBefore((OTC_AVLNode*)this);
      else
	theParent->addAfter((OTC_AVLNode*)this);
    }
  }
  else
    globAgents->addRoot((OTC_AVLNode*)this);

  _mutex.unlock();
}

/* ------------------------------------------------------------------------- */
