/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     dispatch/otcevent.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 OTC LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/dispatch/event.hh"
#endif

#include <OTC/dispatch/event.hh>
#include <OTC/dispatch/eventjob.hh>
#include <OTC/dispatch/evagent.hh>
#include <OTC/dispatch/dispatch.hh>
#include <OTC/debug/logstrm.hh>

/* ------------------------------------------------------------------------- */
OTC_NRMutex OTC_Event::_mutex;

/* ------------------------------------------------------------------------- */
OTC_Event::~OTC_Event()
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
void OTC_Event::deliver(OTC_EVAgent* theAgent)
{
  OTCLIB_ENSURE((theAgent != 0),
   "OTC_Event::deliver() - invalid agent");

  theAgent->handle(this);
}

/* ------------------------------------------------------------------------- */
void OTC_Event::deliver(int theAgentId)
{
  OTC_EVAgent* theAgent;
  theAgent = OTC_EVAgent::lookup(theAgentId);

  if (theAgent != 0)
  {
    theAgent->handle(this);
  }
  else
  {
    OTCLIB_LOGGER(OTCLIB_LOG_WARNING) <<
     "OTC_Event::deliver() - event discarded" << flush;
    OTCLIB_LOGGER(OTCLIB_LOG_DEBUG) <<
     "Agent " << theAgentId << flush;
    OTCLIB_LOGGER(OTCLIB_LOG_DEBUG)
     << "Event " << *this << flush;

    cancelSource(theAgentId);
    destroy();
  }
}

/* ------------------------------------------------------------------------- */
void OTC_Event::queue(int theAgentId, int theOptions)
{
  OTC_EventJob* theJob;
  theJob = new OTC_EventJob(theAgentId,this);
  OTCLIB_ASSERT(theJob != 0);

  OTC_Dispatcher::schedule(theJob,theOptions);
}

/* ------------------------------------------------------------------------- */
OTC_Message* OTC_Event::deflate() const
{
  return 0;
}

/* ------------------------------------------------------------------------- */
OTC_Event* OTC_Event::clone()
{
  _mutex.lock();

  myRefCount++;

  _mutex.unlock();

  return this;
}

/* ------------------------------------------------------------------------- */
void OTC_Event::destroy()
{
  _mutex.lock();

  OTCLIB_ASSERT(myRefCount != 0);
  if (--myRefCount == 0)
    delete this;

  _mutex.unlock();
}

/* ------------------------------------------------------------------------- */
void OTC_Event::cancelSource(int /* theAgentId */)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
