/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     dispatch/otceventjob.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 OTC LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/dispatch/eventjob.hh"
#endif

#include <OTC/dispatch/eventjob.hh>
#include <OTC/dispatch/evagent.hh>
#include <OTC/dispatch/event.hh>

/* ------------------------------------------------------------------------- */
OTC_EventJob::~OTC_EventJob()
{
  if (myEvent != 0)
    myEvent->destroy();
}

/* ------------------------------------------------------------------------- */
OTC_EventJob::OTC_EventJob(int theAgentId, OTC_Event* theEvent)
  : myTarget(theAgentId), myEvent(theEvent)
{
  OTCLIB_ENSURE((theEvent != 0),
   "OTC_EventJob::OTC_EventJob() invalid event");
}

/* ------------------------------------------------------------------------- */
void OTC_EventJob::execute()
{
  OTCLIB_ENSURE((myEvent != 0),
   "OTC_EventJob::execute() - invalid event");

  myEvent->deliver(myTarget);

  myEvent = 0;
}

/* ------------------------------------------------------------------------- */
