/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     dispatch/otcjobqueue.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 OTC LIMITED
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/dispatch/jobqueue.hh"
#endif

#include <OTC/dispatch/jobqueue.hh>
#include <OTC/dispatch/event.hh>

/* ------------------------------------------------------------------------- */
OTC_JobQueue::~OTC_JobQueue()
{
  OTC_LinkIterator theJobs = myJobs.items();
  theJobs.resetFirst();
  while (theJobs.isLink())
  {
    OTC_Job* theJob;
    theJob = (OTC_Job*)((OTC_VLink*)theJobs.link())->item();
    theJob->destroy();
  }
}

/* ------------------------------------------------------------------------- */
OTC_Boolean OTC_JobQueue::isEmpty() const
{
  return myJobs.isEmpty();
}

/* ------------------------------------------------------------------------- */
void OTC_JobQueue::add(OTC_Job* theJob, int)
{
  OTCLIB_ENSURE((theJob != 0),
   "OTC_JobQueue::add() - invalid job");

  OTC_VLink* theLink;
  theLink = new OTC_VLink((void*)theJob);
  OTCLIB_ASSERT(theLink != 0);
  myJobs.addLast(theLink);
}

/* ------------------------------------------------------------------------- */
OTC_Job* OTC_JobQueue::next(int, int)
{
  if (myJobs.isEmpty())
    return 0;

  OTC_Job* theJob;
  theJob = (OTC_Job*)((OTC_VLink*)myJobs.first())->item();
  myJobs.removeFirst();

  return theJob;
}

/* ------------------------------------------------------------------------- */
