/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     files/otcstat.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 OTC LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/files/stat.hh"
#endif

#include <OTC/files/stat.hh>

#include <string.h>

#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif

#ifdef NEED_MEMSET
extern "C" void* memset(void*, int, int);
#endif
#ifdef NEED_MEMCPY
extern "C" void* memcpy(void*, void const*, int);
#endif

#if defined(ENV_OSTORE)
/* ------------------------------------------------------------------------- */
os_typespec* OTC_Stat::typespec()
{
  static os_typespec ts("OTC_Stat");
  return &ts;
}
#endif

/* ------------------------------------------------------------------------- */
OTC_Stat::OTC_Stat()
{
  memset(&myStat,0,sizeof(myStat));
}

/* ------------------------------------------------------------------------- */
OTC_Stat::OTC_Stat(OTC_Stat const& theStat)
{
  memcpy(&myStat,&theStat.myStat,sizeof(myStat));
}

/* ------------------------------------------------------------------------- */
OTC_Stat& OTC_Stat::operator=(OTC_Stat const& theStat)
{
  memcpy(&myStat,&theStat.myStat,sizeof(myStat));
  return *this;
}

/* ------------------------------------------------------------------------- */
