/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     memory/_cmmnpool.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/memory/cmmnpool.hh>
#include <OTC/debug/tracer.hh>

#include <stdlib.h>

/* ------------------------------------------------------------------------- */

void test1()
{
  OTC_Tracer tracer("void test1()");

  void* mem1;

  mem1 = OTC_CommonPool::allocate(4);
  OTC_CommonPool::release(mem1,4);

  for (size_t i=1; i<=OTC_CommonPool::numPools(); i++)
  {
    OTC_Pool const* thePool = OTC_CommonPool::pool(i);
    tracer() << "pool = " << i << endl;
    tracer() << "pool.elementSize() = " << thePool->elementSize() << endl;
    tracer() << "pool.blockSize() = " << thePool->blockSize() << endl;
    tracer() << "pool.elementCount() = " << thePool->elementCount() << endl;
    tracer() << "pool.capacity() = " << thePool->capacity() << endl;
    tracer() << "pool.allocated() = " << thePool->allocated() << endl;
  }
}

typedef void (*testFunc)();

testFunc tests[] =
{
  test1
};

/* ------------------------------------------------------------------------- */

main(int argc, char* argv[])
{
  u_int const numTests = sizeof(tests)/sizeof(tests[0]);

  set_terminate(otclib_terminate_handler);

  if (argc != 2)
  {
    cout << numTests << endl;
    return 1;
  }
  else
  {
    int testNum = atoi(argv[1]);
    if (testNum > 0 && u_int(testNum) <= numTests)
    {
      tests[testNum-1]();
      return 0;
    }
    else
      return 1;
  }
}

/* ------------------------------------------------------------------------- */
