/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     memory/otccluster.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1994 TELSTRA CORPORATION LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/memory/cluster.hh"
#endif

#include <OTC/memory/cluster.hh>
#include <OTC/memory/mcobject.hh>
#include <OTC/memory/arena.hh>

/* ------------------------------------------------------------------------- */
OTC_Cluster::OTC_Cluster()
  : myObjects(0)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
OTC_Cluster::OTC_Cluster(size_t theBlockSize, size_t theSlop)
  : myArena(theBlockSize,theSlop), myObjects(0)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
OTC_Cluster::~OTC_Cluster()
{
  while (myObjects != 0)
  {
    OTC_MCObject* theNext = myObjects->myNext;
    delete myObjects;
    myObjects = theNext;
  }
}

/* ------------------------------------------------------------------------- */
