/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     memory/otccmmnpool.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 OTC LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/memory/cmmnpool.hh"
#endif

#include <OTC/memory/cmmnpool.hh>
#include <OTC/memory/pool.hh>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

/* ------------------------------------------------------------------------- */
OTC_NRMutex OTC_CommonPool::_mutex;
OTC_Boolean OTC_CommonPool::myInit = OTCLIB_FALSE;
OTC_Boolean OTC_CommonPool::myDisable = OTCLIB_FALSE;
OTC_Pool** OTC_CommonPool::myPools = 0;
u_int OTC_CommonPool::myNumPools = 0;
size_t OTC_CommonPool::myIncrement = 0;
size_t OTC_CommonPool::myLargest = 0;
u_int* OTC_CommonPool::myIndex = 0;

/* ------------------------------------------------------------------------- */
void OTC_CommonPool::initialise()
{
  // This function does not lock the thread mutex as it is expected that it
  // is locked by the allocate() function. Avoids having a recursive mutex.

  myInit = OTCLIB_TRUE;

  if (getenv("OTCLIB_NOCOMMONPOOL") != 0)
    myDisable = OTCLIB_TRUE;

  if (myDisable == OTCLIB_FALSE && myPools == 0)
  {
    // Initialise statics here. Do this in order to avoid problems with
    // initialised static data in SunOS 4 Shared libraries.

    myNumPools = 8;
    myIncrement = sizeof(double);

    myLargest = myNumPools * myIncrement;

    myPools = new OTC_Pool*[myNumPools];
    OTCLIB_ASSERT(myPools != 0);

    char tmpBuffer1[64];
    char tmpBuffer2[64];

    strcpy(tmpBuffer1,"OTCLIB_POOLBLOCKSIZE_");
    strcpy(tmpBuffer2,"OTCLIB_POOLPREALLOCATE_");

    char* tmpPointer1 = tmpBuffer1 + strlen(tmpBuffer1);
    char* tmpPointer2 = tmpBuffer2 + strlen(tmpBuffer2);

    size_t theSize = myIncrement;
    for (u_int i=0; i<myNumPools; i++)
    {
      char* theVariable = 0;

      int theBlockSize = -1;
      int thePreAllocate = -1;

      sprintf(tmpPointer1,"%d",i+1);
      theVariable = getenv(tmpBuffer1);
      if (theVariable != 0)
	theBlockSize = atoi(theVariable);

      sprintf(tmpPointer2,"%d",i+1);
      theVariable = getenv(tmpBuffer2);
      if (theVariable != 0)
	thePreAllocate = atoi(theVariable);

      if (theBlockSize > 0)
	myPools[i] = new OTC_Pool(theSize,theBlockSize);
      else
	myPools[i] = new OTC_Pool(theSize);

      OTCLIB_ASSERT(myPools[i] != 0);

      if (thePreAllocate != -1)
	myPools[i]->grabMemory(thePreAllocate);

      theSize += myIncrement;
    }

    myIndex = new u_int[myLargest+1];
    OTCLIB_ASSERT(myIndex != 0);

    myIndex[0] = 0;
    for (u_int j=1; j<=myLargest; j++)
      myIndex[j] = (j-1)/myIncrement;
  }
}

/* ------------------------------------------------------------------------- */
void* OTC_CommonPool::allocate(size_t theSize)
{
  void* theData;

  _mutex.lock();

  if (myInit == OTCLIB_FALSE)
    initialise();

  if (!myDisable && (theSize <= myLargest))
    theData = myPools[myIndex[theSize]]->allocate();
  else
    theData = new char[theSize];

  _mutex.unlock();

  return theData;
}

/* ------------------------------------------------------------------------- */
void OTC_CommonPool::release(void* theMemory, size_t theSize)
{
  _mutex.lock();

  if (!myDisable && (theSize <= myLargest))
    myPools[myIndex[theSize]]->release(theMemory);
  else
    delete [] theMemory;

  _mutex.unlock();
}

/* ------------------------------------------------------------------------- */
