/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     memory/otcmcobject.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1994 TELSTRA CORPORATION LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/memory/mcobject.hh"
#endif

#include <OTC/memory/mcobject.hh>
#include <OTC/memory/cluster.hh>
#include <OTC/memory/cmmnpool.hh>

/* ------------------------------------------------------------------------- */
class OTC_ClusterData
{
  public:

    void*		operator new(size_t theSize)
				{ return OTC_CommonPool::allocate(theSize); }

    void		operator delete(void* theMemory, size_t theSize)
				{ OTC_CommonPool::release(theMemory,theSize); }

    OTC_Cluster*	cluster;

    OTC_ClusterData*	next;
};

/* ------------------------------------------------------------------------- */
OTC_Cluster* OTC_MCObject::globCluster = 0;
OTC_ClusterData* OTC_MCObject::globChain = 0;

/* ------------------------------------------------------------------------- */
OTC_MCObject::OTC_MCObject()
  : myNext(0)
{
  OTCLIB_ASSERT(globCluster != 0 || globChain != 0);

  myNext = globCluster->myObjects;
  globCluster->myObjects = this;

  if (globChain != 0)
  {
    globCluster = globChain->cluster;

    OTC_ClusterData* tmpChain = globChain;
    globChain = globChain->next;
    delete tmpChain;
  }
  else
    globCluster = 0;
}

/* ------------------------------------------------------------------------- */
OTC_MCObject::~OTC_MCObject()
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
void* OTC_MCObject::operator new(size_t theSize, OTC_Cluster& theCluster)
{
  if (globCluster != 0)
  {
    OTC_ClusterData* tmpChain = new OTC_ClusterData;
    OTCLIB_ASSERT(tmpChain != 0);
    tmpChain->next = globChain;
    tmpChain->cluster = globCluster;
    globChain = tmpChain;
  }

  globCluster = &theCluster;

  return theCluster.myArena.allocate(theSize);
}

/* ------------------------------------------------------------------------- */
void* OTC_MCObject::operator new(size_t)
{
  OTCLIB_EXCEPTION(
   "OTC_MCObject::operator new(size_t) - Shouldn't be callable");

  return 0;
}

/* ------------------------------------------------------------------------- */
