/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     options/otcoptions.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
//
// = COPYRIGHT
//     Copyright 1992 OTC LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/options/options.hh"
#endif

#include <OTC/options/options.hh>

#include <ctype.h>

#if defined(ENV_OSTORE)
/* ------------------------------------------------------------------------- */
os_typespec* OTC_Options::typespec()
{
  static os_typespec ts("OTC_Options");
  return &ts;
}
#endif

/* ------------------------------------------------------------------------- */
OTC_Options::OTC_Options()
 : myOffset(0)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
OTC_Options::OTC_Options(int argc, char* argv[])
 : myOffset(0)
{
  initialise(argc,argv);
}

/* ------------------------------------------------------------------------- */
OTC_Options::OTC_Options(char const* theArgs)
 : myOffset(0)
{
  initialise(theArgs);
}

/* ------------------------------------------------------------------------- */
OTC_Options::OTC_Options(OTC_Options const& theOptions)
{
  myOffset = theOptions.myOffset;
  myOptions = theOptions.myOptions;
}

/* ------------------------------------------------------------------------- */
OTC_Options& OTC_Options::operator=(OTC_Options const& theOptions)
{
  myOffset = theOptions.myOffset;
  myOptions = theOptions.myOptions;
  return *this;
}

/* ------------------------------------------------------------------------- */
void OTC_Options::initialise(int argc, char* argv[])
{
  OTCLIB_ENSURE((argv != 0 && argc >= 0),
   "OTC_Options::initialise() - Invalid arguments");

  myOffset = 0;
  myOptions.removeAll();
  for (int i=0; i<argc; i++)
    myOptions.addLast(argv[i]);
}

/* ------------------------------------------------------------------------- */
void OTC_Options::initialise(char const* theArgs)
{
  OTCLIB_ENSURE((theArgs != 0),
   "OTC_Options::initialise() - Invalid argument");

  myOffset = 0;
  myOptions.removeAll();

  // Skip initial whitespace.

  while (*theArgs && isspace(*theArgs))
    theArgs++;
  if (!*theArgs)
    return;

  // Now for the rest.

  OTC_String anArg;
  OTC_Boolean inString = OTCLIB_FALSE;
  while (*theArgs)
  {
    if (!inString && isspace(*theArgs))
    {
      myOptions.addLast(anArg);
      anArg.truncate(0);
      while (*theArgs && isspace(*theArgs))
	theArgs++;
      if (!*theArgs)
	return;
      theArgs--;
    }
    else
    {
      switch (*theArgs)
      {
	case '"':
	  inString = inString != OTCLIB_FALSE ? OTCLIB_FALSE : OTCLIB_TRUE;
	  break;

	case '\\':
	  if (*(theArgs+1))
	  {
	    theArgs++;
	    anArg += *theArgs;
	  }
	  break;

	default:
	  anArg += *theArgs;
	  break;
      }
    }
    theArgs++;
  }
  myOptions.addLast(anArg);
}

/* ------------------------------------------------------------------------- */
u_int OTC_Options::numOptions() const
{
  int theNum = myOptions.population() - myOffset;
  return theNum < 0 ? 0 : theNum;
}

/* ------------------------------------------------------------------------- */
OTC_String const& OTC_Options::option(u_int theNum) const
{
  OTCLIB_ENSURE((theNum != 0 && theNum <= numOptions()),
   "OTC_Options::option() - Index out of range");

  return myOptions.item(myOffset+theNum-1);
}

/* ------------------------------------------------------------------------- */
OTC_Iterator<OTC_String> OTC_Options::options(OTC_Direction theDirection) const
{
  OTC_Range range(myOffset,numOptions());
  return myOptions.items(range,theDirection);
}

/* ------------------------------------------------------------------------- */
OTC_Iterator<OTC_String> OTC_Options::options(
 u_int theStart,
 u_int theLength,
 OTC_Direction theDirection
) const
{
  OTC_Range range(myOffset+theStart,theLength);
  return myOptions.items(range,theDirection);
}

/* ------------------------------------------------------------------------- */
OTC_Iterator<OTC_String> OTC_Options::options(
 OTC_Range const& theRange,
 OTC_Direction theDirection
) const
{
  OTC_Range range(myOffset+theRange.lower(),theRange.length());
  return myOptions.items(range,theDirection);
}

/* ------------------------------------------------------------------------- */
