/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     ostore/otclocality.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/ostore/locality.hh>

#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)

/* ------------------------------------------------------------------------- */
OTC_Locality OTC_Locality::of(void const* theMem)
{
#if defined(ENV_OSTORE)
  OTC_Storage* theStorage;
  theStorage = OTC_Storage::first();
  while (theStorage != 0)
  {
    if (theStorage->manages(theMem))
      return theStorage;
    theStorage = theStorage->next();
  }
  
  os_object_cluster* theCluster;
  theCluster = os_object_cluster::of(theMem);
  if (theCluster != 0)
    return theCluster;
#endif

  return OTC_Locality(os_segment::of(theMem));
}

#if !defined(ENV_OSTORE)
/* ------------------------------------------------------------------------- */
OTC_Locality::operator os_segment*() const
{
  return segment();
}
#endif

#if !defined(ENV_OSTORE_DML)
/* ------------------------------------------------------------------------- */
void* operator new(
 size_t theSize,
 OTC_Locality const& theLocality,
 os_typespec* theTypespec
)
{
  if (theLocality.isStorage())
    return theLocality.storage()->allocate(theSize,theTypespec);

  if (theLocality.isCluster())
    return ::operator new (theSize,theLocality.cluster(),theTypespec);

  return ::operator new (theSize,theLocality.segment(),theTypespec);
}

/* ------------------------------------------------------------------------- */
void* operator new(
 size_t theSize,
 OTC_Locality const& theLocality,
 os_typespec* theTypespec,
 os_int32 theNum
)
{
  if (theLocality.isStorage())
    return theLocality.storage()->allocate(theSize,theTypespec,theNum);

  if (theLocality.isCluster())
    return ::operator new (theSize,theLocality.cluster(),theTypespec,theNum);

  return ::operator new (theSize,theLocality.segment(),theTypespec,theNum);
}

/* ------------------------------------------------------------------------- */
#endif

#endif
