/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     ostore/otctypespec.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 TELSTRA CORPORATION LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/ostore/typespec.hh>

#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)

/* ------------------------------------------------------------------------- */

os_typespec* otclib_get_charP()
{
  static os_typespec* myTypeSpec = 0;
  if (!myTypeSpec)
    myTypeSpec = new os_typespec("char*");
  return myTypeSpec;
}

os_typespec* otclib_get_shortP()
{
  static os_typespec* myTypeSpec = 0;
  if (!myTypeSpec)
    myTypeSpec = new os_typespec("short*");
  return myTypeSpec;
}

os_typespec* otclib_get_intP()
{
  static os_typespec* myTypeSpec = 0;
  if (!myTypeSpec)
    myTypeSpec = new os_typespec("int*");
  return myTypeSpec;
}

os_typespec* otclib_get_longP()
{
  static os_typespec* myTypeSpec = 0;
  if (!myTypeSpec)
    myTypeSpec = new os_typespec("long*");
  return myTypeSpec;
}

os_typespec* otclib_get_floatP()
{
  static os_typespec* myTypeSpec = 0;
  if (!myTypeSpec)
    myTypeSpec = new os_typespec("float*");
  return myTypeSpec;
}

os_typespec* otclib_get_doubleP()
{
  static os_typespec* myTypeSpec = 0;
  if (!myTypeSpec)
    myTypeSpec = new os_typespec("double*");
  return myTypeSpec;
}

#if defined(CXX_OS)

os_typespec* OTC_TypeSpec<char>::typespec()
{ return os_typespec::get_char(); }

os_typespec* OTC_TypeSpec<short>::typespec()
{ return os_typespec::get_short(); }

os_typespec* OTC_TypeSpec<int>::typespec()
{ return os_typespec::get_int(); }

os_typespec* OTC_TypeSpec<long>::typespec()
{ return os_typespec::get_long(); }

os_typespec* OTC_TypeSpec<float>::typespec()
{ return os_typespec::get_float(); }

os_typespec* OTC_TypeSpec<double>::typespec()
{ return os_typespec::get_double(); }

os_typespec* OTC_TypeSpec<unsigned char>::typespec()
{ return os_typespec::get_unsigned_char(); }

os_typespec* OTC_TypeSpec<unsigned short>::typespec()
{ return os_typespec::get_unsigned_short(); }

os_typespec* OTC_TypeSpec<unsigned int>::typespec()
{ return os_typespec::get_unsigned_int(); }

os_typespec* OTC_TypeSpec<unsigned long>::typespec()
{ return os_typespec::get_unsigned_long(); }


os_typespec* OTC_TypeSpec<void*>::typespec()
{ return os_typespec::get_pointer(); }

os_typespec* OTC_TypeSpec<void const*>::typespec()
{ return os_typespec::get_pointer(); }


os_typespec* OTC_TypeSpec<char*>::typespec()
{ return otclib_get_charP(); }

os_typespec* OTC_TypeSpec<short*>::typespec()
{ return otclib_get_shortP(); }

os_typespec* OTC_TypeSpec<int*>::typespec()
{ return otclib_get_intP(); }

os_typespec* OTC_TypeSpec<long*>::typespec()
{ return otclib_get_longP(); }

os_typespec* OTC_TypeSpec<float*>::typespec()
{ return otclib_get_floatP(); }

os_typespec* OTC_TypeSpec<double*>::typespec()
{ return otclib_get_doubleP(); }


os_typespec* OTC_TypeSpec<char const*>::typespec()
{ return otclib_get_charP(); }

os_typespec* OTC_TypeSpec<short const*>::typespec()
{ return otclib_get_shortP(); }

os_typespec* OTC_TypeSpec<int const*>::typespec()
{ return otclib_get_intP(); }

os_typespec* OTC_TypeSpec<long const*>::typespec()
{ return otclib_get_longP(); }

os_typespec* OTC_TypeSpec<float const*>::typespec()
{ return otclib_get_floatP(); }

os_typespec* OTC_TypeSpec<double const*>::typespec()
{ return otclib_get_doubleP(); }

#endif

/* ------------------------------------------------------------------------- */

#endif
