/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     program/_program.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
//
// = COPYRIGHT
//     Copyright 1992 OTC LIMITED
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/program/program.hh>
#include <OTC/debug/tracer.hh>
#include <OTC/OTC.h>

#include <stdlib.h>

/* ------------------------------------------------------------------------- */

char* argv1[] =
{
  "program", "arg1", "arg2", 0
};

void test1()
{
  OTC_Tracer tracer("void test1()");

  OTC_Program::initialise(3,argv1);
  tracer() << "name = " << OTC_Program::name() << endl;
  tracer() << "numOptions = " << OTC_Program::numOptions() << endl;
  for (int i=0; i<=OTC_Program::numOptions(); i++)
    tracer() << "option " << i << " = " << OTC_Program::option(i) << endl;
  OTC_Iterator<OTC_String> options(OTC_Program::options());
  tracer() << "all options =";
  for (options.reset(); options.isValid(); options.next())
    tracer() << " " << options.item();
  tracer() << endl;
}

char* argv2[] =
{
  "program", "-v", "-DONE", "+i", "-DTWO=TWO", "one.h", "two.h", 0
};

void test2()
{
  OTC_Tracer tracer("void test2()");

  OTC_Program::initialise(7,argv2);
  tracer() << "name = " << OTC_Program::name() << endl;
  tracer() << "numOptions = " << OTC_Program::numOptions() << endl;

  while (OTC_Program::numOptions() != 0)
  {
    if (OTC_Program::match("-D*=*"))
    {
      tracer() << "define+value - " << OTC_Program::option() << endl;
      OTC_Program::shift();
    }
    else if (OTC_Program::match("-D*"))
    {
      tracer() << "define - " << OTC_Program::option() << endl;
      OTC_Program::shift();
    }
    else if (OTC_Program::match("[+-]*"))
    {
      tracer() << "option - " << OTC_Program::option() << endl;
      OTC_Program::shift();
    }
    else if (OTC_Program::match("*.h"))
    {
      tracer() << "file - " << OTC_Program::option() << endl;
      OTC_Program::shift();
    }
    else
    {
      tracer() << "all - " << OTC_Program::option() << endl;
      OTC_Program::shift();
    }
  }
  OTC_Program::restore();
}

/* ------------------------------------------------------------------------- */

typedef void (*testFunc)();

testFunc tests[] =
{
  test1,
  test2
};

/* ------------------------------------------------------------------------- */

main(int argc, char* argv[])
{
  u_int const numTests = sizeof(tests)/sizeof(tests[0]);

  set_terminate(otclib_terminate_function);

  if (argc != 2)
  {
    cout << numTests << endl;
    return 1;
  }
  else
  {
    int testNum = atoi(argv[1]);
    if (testNum > 0 && u_int(testNum) <= numTests)
    {
      tests[testNum-1]();
      return 0;
    }
    else
      return 1;
  }
}

/* ------------------------------------------------------------------------- */
