/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     program/otcprogram.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
//
// = COPYRIGHT
//     Copyright 1992 OTC LIMITED
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/program/program.hh"
#endif

#include <OTC/files/pathname.hh>
#include <OTC/program/program.hh>
#include <OTC/text/globex.hh>

/* ------------------------------------------------------------------------- */
OTC_String* OTC_Program::myName = 0;
OTC_Options* OTC_Program::myOptions = 0;
OTC_String* OTC_Program::myBasename = 0;
OTC_String* OTC_Program::myDirname = 0;

/* ------------------------------------------------------------------------- */
void OTC_Program::initialise(int argc, char* argv[])
{
  OTCLIB_ENSURE((argv != 0 && argc > 0),
   "OTC_Program::initialise) - Invalid arguments");
  OTCLIB_ENSURE((myName == 0 && myOptions == 0),
   "OTC_Program::initialise() - Class already initialised");

  myName = new OTC_String;
  OTCLIB_ASSERT(myName != 0);
  myOptions = new OTC_Options;
  OTCLIB_ASSERT(myOptions != 0);

  myName->assign(argv[0]);
  if (argc > 1)
    myOptions->initialise(argc-1,argv+1);
}

/* ------------------------------------------------------------------------- */
OTC_String const& OTC_Program::name()
{
  OTCLIB_ENSURE((myName != 0),
   "OTC_Program::name() - Class not initialised");
  return *myName;
}

/* ------------------------------------------------------------------------- */
int OTC_Program::numOptions()
{
  if (myOptions == 0)
    return -1;

  return myOptions->numOptions();
}

/* ------------------------------------------------------------------------- */
OTC_String const& OTC_Program::option(u_int theNum)
{
  OTCLIB_ENSURE((myName != 0 && myOptions != 0),
   "OTC_Program::option() - Class not initialised");
  OTCLIB_ENSURE((theNum <= myOptions->numOptions()),
   "OTC_Program::option() - Invalid option number");

  if (theNum == 0)
    return *myName;

  return myOptions->option(theNum);
}

/* ------------------------------------------------------------------------- */
OTC_Boolean OTC_Program::optionMatches(u_int theNum, char const* thePattern)
{
  OTCLIB_ENSURE((myName != 0 && myOptions != 0),
   "OTC_Program::option() - Class not initialised");
  OTCLIB_ENSURE((theNum <= myOptions->numOptions()),
   "OTC_Program::option() - Invalid option number");

  OTC_Globex tmpPattern(thePattern);

  if (theNum == 0)
    return tmpPattern.match(*myName);

  return tmpPattern.match(myOptions->option(theNum));
}

/* ------------------------------------------------------------------------- */
OTC_Iterator<OTC_String> OTC_Program::options(OTC_Direction theDirection)
{
  OTCLIB_ENSURE((myOptions != 0),
   "OTC_Program::options() - Class not initialised");
  return myOptions->options(theDirection);
}

/* ------------------------------------------------------------------------- */
OTC_Iterator<OTC_String> OTC_Program::options(
 u_int theStart,
 u_int theLength,
 OTC_Direction theDirection
)
{
  OTCLIB_ENSURE((myOptions != 0),
   "OTC_Program::options() - Class not initialised");
  return myOptions->options(theStart,theLength,theDirection);
}

/* ------------------------------------------------------------------------- */
OTC_Iterator<OTC_String> OTC_Program::options(
 OTC_Range const& theRange,
 OTC_Direction theDirection
)
{
  OTCLIB_ENSURE((myOptions != 0),
   "OTC_Program::options() - Class not initialised");
  return myOptions->options(theRange,theDirection);
}

/* ------------------------------------------------------------------------- */
void OTC_Program::shift(u_int theNum)
{
  OTCLIB_ENSURE((myOptions != 0),
   "OTC_Program::shift() - Class not initialised");
  myOptions->shift(theNum);
}

/* ------------------------------------------------------------------------- */
void OTC_Program::restore()
{
  OTCLIB_ENSURE((myOptions != 0),
   "OTC_Program::restore() - Class not initialised");
  myOptions->restore();
}

/* ------------------------------------------------------------------------- */
OTC_String const& OTC_Program::basename()
{
  if (myBasename == 0)
  {
    OTC_Pathname path = name();

    myBasename = new OTC_String(path.basename());
    OTCLIB_ASSERT(myBasename != 0);
  }

  return *myBasename;
}

/* ------------------------------------------------------------------------- */
OTC_String const& OTC_Program::dirname()
{
  if (myDirname == 0)
  {
    OTC_Pathname path = name();

    myDirname = new OTC_String(path.dirname());
    OTCLIB_ASSERT(myDirname != 0);
  }

  return *myDirname;
}

/* ------------------------------------------------------------------------- */
