/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     refcnt/otcresource.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
//
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// = NOTES
//     GNU C++ will not let you call <delete> on an object when the object
//     is <const>. Thus forcibly cast <this> pointer to non const object.
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/refcnt/resource.hh"
#endif

#include <OTC/refcnt/resource.hh>
#include <OTC/memory/cmmnpool.hh>

#include <stdlib.h>

/* ------------------------------------------------------------------------- */
OTC_Boolean OTC_Resource::globAllocatedUsingNew = OTCLIB_FALSE;
OTC_Boolean OTC_Resource::globInitialised = OTCLIB_FALSE;
OTC_Boolean OTC_Resource::globResourceWarnings = OTCLIB_FALSE;

/* ------------------------------------------------------------------------- */
OTC_Resource::OTC_Resource()
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
  myRefCount = new ((os_segment*)theLocality) OTC_Count;
#else
#if defined(ENV_OSTORE)
  myRefCount = new (theLocality,OTC_Count::get_os_typespec()) OTC_Count;
#else
  myRefCount = new OTC_Count;
#endif
#endif
  OTCLIB_ASSERT(myRefCount != 0);

#if !defined(ENV_OSTORE_DML) && !defined(ENV_OSTORE) && !defined(ENV_THREADS)

  if (globInitialised == OTCLIB_FALSE)
  {
    globInitialised = OTCLIB_TRUE;
    char* env = getenv("OTCLIB_RESOURCEWARNINGS");
    if (env != 0)
      globResourceWarnings = OTCLIB_TRUE;
  }

  myAllocatedUsingNew = globAllocatedUsingNew;
  globAllocatedUsingNew = OTCLIB_FALSE;
#endif
}

/* ------------------------------------------------------------------------- */
OTC_Resource::~OTC_Resource()
{
  OTCLIB_ENSURE((numRefs() == 0),
   "OTC_Resource::~OTC_Resource() - Object still referenced");

  delete myRefCount;
}

/* ------------------------------------------------------------------------- */
u_int OTC_Resource::numRefs() const
{
  return myRefCount->count();
}

/* ------------------------------------------------------------------------- */
u_int OTC_Resource::reference() const
{
#if !defined(ENV_OSTORE_DML) && !defined(ENV_OSTORE) && !defined(ENV_THREADS)
  if (globResourceWarnings != OTCLIB_FALSE)
  {
    if (myAllocatedUsingNew == OTCLIB_FALSE)
    {
      OTCLIB_WARNING(
       "OTC_Resource::reference() - Object not allocated using new");
    }
  }
#endif

  myRefCount->inc();
  return myRefCount->count();
}

/* ------------------------------------------------------------------------- */
u_int OTC_Resource::unReference() const
{
#if !defined(ENV_OSTORE_DML) && !defined(ENV_OSTORE) && !defined(ENV_THREADS)
  if (globResourceWarnings != OTCLIB_FALSE)
  {
    if (myAllocatedUsingNew == OTCLIB_FALSE)
    {
      OTCLIB_WARNING(
       "OTC_Resource::unReference() - Object not allocated using new");
    }
  }
#endif

  OTCLIB_ENSURE((numRefs() != 0),
   "OTC_Resource::unReference() - Object not referenced");

  myRefCount->dec();
  u_int theCount = myRefCount->count();
  if (theCount == 0)
    delete (OTC_Resource*)this;
  return theCount;
}

#if !defined(ENV_OSTORE_DML) && !defined(ENV_OSTORE) && !defined(ENV_THREADS)
/* ------------------------------------------------------------------------- */
void* OTC_Resource::operator new(size_t theSize)
{
  doInOperatorNew();

#if defined(ENV_NOCOMMONPOOL)
  return ::operator new(theSize);
#else
  return OTC_MPObject::operator new(theSize);
#endif
}

/* ------------------------------------------------------------------------- */
void OTC_Resource::operator delete(void* theMem, size_t theSz)
{
#if defined(ENV_NOCOMMONPOOL)
  ::operator delete(theMem);
#else
  OTC_MPObject::operator delete(theMem,theSz);
#endif
}
#endif

/* ------------------------------------------------------------------------- */
