/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     text/_symbol.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 OTC LIMITED
//
// ============================================================================
*/

#include <OTC/text/symbol.hh>

#include <OTC/debug/tracer.hh>

#include <stdlib.h>
#include <fstream.h>

/* ------------------------------------------------------------------------- */

void test1()
{
  OTC_Tracer tracer("void test1()");

  OTC_Symbol sym1 = "one";
  OTC_Symbol sym2 = "two";
  OTC_Symbol sym3 = "three";
  OTC_Symbol sym4 = "four";
  OTC_Symbol sym5 = "five";

  tracer() << "sym1(" << int(sym1.string()) << ") = " << sym1 << endl;
  tracer() << "sym2(" << int(sym2.string()) << ") = " << sym2 << endl;
  tracer() << "sym3(" << int(sym3.string()) << ") = " << sym3 << endl;
  tracer() << "sym4(" << int(sym4.string()) << ") = " << sym4 << endl;
  tracer() << "sym5(" << int(sym5.string()) << ") = " << sym5 << endl;

  tracer() << "(sym1 == \"one\") = " << (sym1 == "one") << endl;
  tracer() << "(sym1 != \"one\") = " << (sym1 != "one") << endl;
  tracer() << "(\"one\" == sym1) = " << ("one" == sym1) << endl;
  tracer() << "(\"one\" != sym1) = " << ("one" != sym1) << endl;

  OTC_String str1 = "eno";
  tracer() << "str1 = \"eno\"" << endl;

  tracer() << "(sym1 == str1) = " << (sym1 == str1) << endl;
  tracer() << "(sym1 != str1) = " << (sym1 != str1) << endl;
  tracer() << "(str1 == sym1) = " << (str1 == sym1) << endl;
  tracer() << "(str1 != sym1) = " << (str1 != sym1) << endl;

  tracer() << "exists(str) = " << OTC_Symbol::exists(str1) << endl;
}

void test2()
{
  OTC_Tracer tracer("void test2()");

  char buf[1024];
  ifstream in("/usr/dict/words");

  OTC_Symbol s1;

  while (in.good())
  {
    in >> buf;
    if (!in.fail())
      s1 = buf;
  }

  cout << "loaded" << endl;
  cout << "> " << flush;

  OTC_String theString;
  while (cin.good())
  {
    OTC_String::getline(theString,cin);
    if (!cin.fail())
    {
      if (!OTC_Symbol::exists(theString))
	cout << "create --> " << flush;

      s1 = theString;
      theString = s1;
      s1 = theString;
      cout << s1 << " = " << int(s1.string()) << endl;
      cout << "> " << flush;
      theString.truncate();
    }
  }
}

void test3()
{
  OTC_Tracer tracer("void test3()");

  OTC_Symbol theSymbol = "";

  cout << "\"" << theSymbol << "\"" << endl;
}

void test4()
{
  OTC_Tracer tracer("void test4()");

  OTC_Symbol theSymbol = OTC_Symbol::nullSymbol();

  cout << "\"" << theSymbol << "\"" << endl;
}

typedef void (*testFunc)();

testFunc tests[] =
{
  test1,
  test2,
  test3,
  test4
};

/* ------------------------------------------------------------------------- */

main(int argc, char* argv[])
{
  u_int const numTests = sizeof(tests)/sizeof(tests[0]);

  set_terminate(otclib_terminate_handler);

  if (argc != 2)
  {
    cout << numTests << endl;
    return 1;
  }
  else
  {
    int testNum = atoi(argv[1]);
    if (testNum > 0 && u_int(testNum) <= numTests)
    {
      tests[testNum-1]();
      return 0;
    }
    else
      return 1;
  }
}

/* ------------------------------------------------------------------------- */
