/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     text/otccstring.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1994 TELSTRA CORPORATION LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/text/cstring.hh"
#endif

#include <OTC/text/cstring.hh>
#include <OTC/collctn/copyactn.hh>

#include <string.h>

#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif

#ifdef NEED_MEMSET
extern "C" void* memset(void*, int, int);
#endif

#if defined(ENV_OSTORE)
/* ------------------------------------------------------------------------- */
os_typespec* OTC_CString::typespec()
{
  static os_typespec ts("OTC_CString");
  return &ts;
}
#endif

/* ------------------------------------------------------------------------- */
OTC_CString::~OTC_CString()
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
OTC_CString::OTC_CString(char const* theString)
  : myData((theString ? ::strlen(theString) : 0),OTCLIB_UNBUFFERED)
{
  if (theString != 0)
    OTC_CopyActions<char>::copy(myData.string(),theString,myData.length());
}

/* ------------------------------------------------------------------------- */
OTC_CString::OTC_CString(char theChar, u_int theNum)
  : myData(theNum,OTCLIB_UNBUFFERED)
{
  memset(myData.string(),theChar,myData.length());
}

/* ------------------------------------------------------------------------- */
OTC_CString::OTC_CString(char const* theString, u_int theNum)
  : myData(theNum,OTCLIB_UNBUFFERED)
{
  OTCLIB_ENSURE((theNum == 0 || theString != 0),
   "OTC_CString(char const*, u_int) - null string but non zero length");

  if (theString != 0)
    OTC_CopyActions<char>::copy(myData.string(),theString,theNum);
}

/* ------------------------------------------------------------------------- */
