/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     text/otcpattern.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
//
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/text/pattern.hh"
#endif

#include <OTC/text/pattern.hh>

#include <string.h>

/* ------------------------------------------------------------------------- */
OTC_Pattern::OTC_Pattern(char const* thePattern)
{
  OTCLIB_ENSURE((thePattern != 0),
   "OTC_Pattern::OTC_Pattern() - Invalid argument");

  myPattern = new char[strlen(thePattern)+1];
  OTCLIB_ASSERT(myPattern != 0);
  strcpy(myPattern,thePattern);
}

/* ------------------------------------------------------------------------- */
OTC_Pattern::~OTC_Pattern()
{
  delete myPattern;
}

/* ------------------------------------------------------------------------- */
OTC_Range OTC_Pattern::range() const
{
  return OTC_Range(start(),length());
}

/* ------------------------------------------------------------------------- */
u_int OTC_Pattern::start(u_int) const
{
  return 0;
}

/* ------------------------------------------------------------------------- */
u_int OTC_Pattern::length(u_int) const
{
  return 0;
}

/* ------------------------------------------------------------------------- */
