/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     text/otcrecord.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
//
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/text/record.hh"
#endif

#include <OTC/text/record.hh>
#include <OTC/collctn/bitsetc.hh>

#include <strstream.h>
#include <string.h>
#include <ctype.h>

#if defined(ENV_OSTORE)
/* ------------------------------------------------------------------------- */
os_typespec* OTC_Record::typespec()
{
  static os_typespec ts("OTC_Record");
  return &ts;
}
#endif

/* ------------------------------------------------------------------------- */
OTC_Record::OTC_Record(OTC_String const& theString)
 : myRecord(theString)
{
  split(" \n\t\r\f",OTCLIB_FALSE);
}

/* ------------------------------------------------------------------------- */
OTC_Record::OTC_Record(OTC_String const& theString, char theFS)
 : myRecord(theString)
{
  split(theFS,OTCLIB_TRUE);
}

/* ------------------------------------------------------------------------- */
OTC_Record::OTC_Record(OTC_String const& theString, OTC_String const& theFS)
 : myRecord(theString)
{
  OTCLIB_ENSURE((!theFS.isEmpty()),
   "OTC_Record::OTC_Record() - Must supply at least one separator");

  split(theFS,OTCLIB_FALSE);
}

/* ------------------------------------------------------------------------- */
OTC_Record::OTC_Record(OTC_Record const& theRecord)
 : myRecord(theRecord.myRecord), myFields(theRecord.myFields)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
OTC_Record& OTC_Record::operator=(OTC_Record const& theRecord)
{
  if (&theRecord != this)
  {
    myRecord = theRecord.myRecord;
    myFields = theRecord.myFields;
  }
  return *this;
}

/* ------------------------------------------------------------------------- */
OTC_String const& OTC_Record::field(u_int theIndex) const
{
  if (theIndex == 0)
    return myRecord;

  else
    return myFields.item(theIndex-1);
}

/* ------------------------------------------------------------------------- */
void OTC_Record::split(OTC_String const& theFS, OTC_Boolean isAwk)
{
  // Construct bitset for field separators.

  OTC_BitSetC ccl(theFS.string(),theFS.length());

  // Cache pointer to string to split up. Also grab the length.

  char const* theString = myRecord.string();
  u_int theLength = myRecord.length();

  // If not using AWK semantics then skip field separators at start of
  // record.

  if (isAwk == OTCLIB_FALSE)
  {
    while (theLength > 0 && ccl.test(*theString) != 0)
    {
      theLength--;
      theString++;
    }
  }

  while (theLength > 0)
  {
    // Find what is in field.

    char const* tmpString1 = theString;
    while (theLength > 0 && ccl.test(*theString) == 0)
    {
      theLength--;
      theString++;
    }

    OTC_CString tmpString2(tmpString1,theString-tmpString1);
    myFields.addLast(tmpString2);

    if (theLength > 0)
    {
      if (isAwk != OTCLIB_FALSE)
      {
	theString++;
	theLength--;
	if (theLength ==0)
	  myFields.addLast(OTC_String::nullString());
      }
      else
      {
	while (theLength > 0 && ccl.test(*theString) != 0)
	{
	  theLength--;
	  theString++;
	}
      }
    }
  }
}

/* ------------------------------------------------------------------------- */
