/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     text/otctracepat.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 TELSTRA CORPORATION LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/text/tracepat.hh"
#endif

#include <OTC/text/tracepat.hh>
#include <OTC/text/regexp.hh>

#include <stdlib.h>

/* ------------------------------------------------------------------------- */
OTC_NRMutex OTC_TracePattern::_mutex;
OTC_Regexp* OTC_TracePattern::globRegexp = 0;
OTC_TracePattern* OTC_TracePattern::globHead = 0;

/* ------------------------------------------------------------------------- */
OTC_TracePattern::OTC_TracePattern(char const* theString)
  : myState(OTCLIB_FALSE), myString(theString)
{
  OTCLIB_ENSURE((theString != 0),
   "OTC_TracePattern::OTC_TracePattern() - invalid string");

  _mutex.lock();

  myPrev = 0;
  myNext = globHead;
  if (globHead != 0)
    globHead->myPrev = this;
  globHead = this;

  if (globRegexp == 0)
  {
    char* thePattern = getenv("OTCLIB_TRACEPATTERN");
    if (thePattern == 0 || *thePattern == EOS)
      thePattern = "^$";

    globRegexp = new OTC_Regexp(thePattern);
    OTCLIB_ASSERT(globRegexp != 0);
  }

  if (globRegexp->isValid() && globRegexp->match(myString))
    myState = OTCLIB_TRUE;

  _mutex.unlock();
}

/* ------------------------------------------------------------------------- */
OTC_TracePattern::~OTC_TracePattern()
{
  _mutex.lock();

  if (globHead == this)
    globHead = myNext;
  if (myPrev != 0)
    myPrev->myNext = myNext;
  if (myNext != 0)
    myNext->myPrev = myPrev;

  _mutex.unlock();
}

/* ------------------------------------------------------------------------- */
OTC_Boolean OTC_TracePattern::enabled() const
{
  return myState;
}

/* ------------------------------------------------------------------------- */
void OTC_TracePattern::set(char const* thePattern)
{
  OTCLIB_ENSURE((thePattern != 0),
   "OTC_TracePattern::set() - invalid pattern");

  _mutex.lock();

  if (globRegexp != 0)
    delete globRegexp;

  if (thePattern == 0 || *thePattern == EOS)
    thePattern = "^$";

  globRegexp = new OTC_Regexp(thePattern);
  OTCLIB_ASSERT(globRegexp != 0);

  OTC_TracePattern* theObject = globHead;
  while (theObject != 0)
  {
    if (globRegexp->isValid() && globRegexp->match(theObject->myString))
      theObject->myState = OTCLIB_TRUE;
    else
      theObject->myState = OTCLIB_FALSE;

    theObject = theObject->myNext;
  }

  _mutex.unlock();
}

/* ------------------------------------------------------------------------- */
