/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     thread/otcnrmutex.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/thread/nrmutex.hh"
#endif

#include <OTC/thread/nrmutex.hh>

#if defined(HAVE_SOLARIS_THREADS)
/* ------------------------------------------------------------------------- */
OTC_NRMutex::OTC_NRMutex()
{
  mutex_init(&_mutex,USYNC_THREAD,0);
  _valid = 1;
}

/* ------------------------------------------------------------------------- */
OTC_NRMutex::~OTC_NRMutex()
{
  _valid = 0;
  mutex_destroy(&_mutex);
}

/* ------------------------------------------------------------------------- */
void OTC_NRMutex::lock()
{
  if (_valid == 0)
    return;

  mutex_lock(&_mutex);
}

/* ------------------------------------------------------------------------- */
void OTC_NRMutex::unlock()
{
  if (_valid == 0)
    return;

  mutex_unlock(&_mutex);
}
#endif

#if defined(HAVE_POSIX_THREADS)
/* ------------------------------------------------------------------------- */
OTC_NRMutex::OTC_NRMutex()
{
  pthread_mutex_init(&_mutex,pthread_mutexattr_default);
  _valid = 1;
}

/* ------------------------------------------------------------------------- */
OTC_NRMutex::~OTC_NRMutex()
{
  _valid = 0;
  pthread_mutex_destroy(&_mutex);
}

/* ------------------------------------------------------------------------- */
void OTC_NRMutex::lock()
{
  if (_valid == 0)
    return;

  pthread_mutex_lock(&_mutex);
}

/* ------------------------------------------------------------------------- */
void OTC_NRMutex::unlock()
{
  if (_valid == 0)
    return;

  pthread_mutex_unlock(&_mutex);
}
#endif

#if defined(HAVE_VXWORKS_THREADS)
/* ------------------------------------------------------------------------- */
OTC_NRMutex::OTC_NRMutex()
{
  _mutex = semMCreate(SEM_Q_PRIORITY|SEM_DELETE_SAFE);(&_mutex,0);
  _valid = 1;
}

/* ------------------------------------------------------------------------- */
OTC_NRMutex::~OTC_NRMutex()
{
  _valid = 0;
  semDelete(_mutex);
}

/* ------------------------------------------------------------------------- */
void OTC_NRMutex::lock()
{
  if (_valid == 0)
    return;

  semTake(_mutex,WAIT_FOREVER);
}

/* ------------------------------------------------------------------------- */
void OTC_NRMutex::unlock()
{
  if (_valid == 0)
    return;

  semGive(_mutex);
}
#endif

#if defined(HAVE_WIN32_THREADS)
/* ------------------------------------------------------------------------- */
OTC_NRMutex::OTC_NRMutex()
{
  _mutex = CreateMutex(0,FALSE,0);
  _valid = 1;
}

/* ------------------------------------------------------------------------- */
OTC_NRMutex::~OTC_NRMutex()
{
  _valid = 0;
  CloseHandle(_mutex);
}

/* ------------------------------------------------------------------------- */
void OTC_NRMutex::lock()
{
  if (_valid == 0)
    return;

  WaitForSingleObject(_mutex,INFINITE);
}

/* ------------------------------------------------------------------------- */
void OTC_NRMutex::unlock()
{
  if (_valid == 0)
    return;

  ReleaseMutex(_mutex);
}
#endif

/* ------------------------------------------------------------------------- */
