/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     types/_date.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
//
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/types/date.hh>

#include <OTC/debug/tracer.hh>

#include <stdlib.h>

/* ------------------------------------------------------------------------- */

void test1()
{
  OTC_Tracer tracer("void test1()");

  OTC_Date date;
  tracer() << date.day() << "/" << date.month() << "/" << date.year() << endl;
}

void test2()
{
  OTC_Tracer tracer("void test2()");

  OTC_Date date(1,1,1);
  tracer() << date.day() << "/" << date.month() << "/" << date.year() << endl;
  date.subtractDays(1);
  tracer() << date.day() << "/" << date.month() << "/" << date.year() << endl;
}

void test3()
{
  OTC_Tracer tracer("void test3()");

  OTC_Date d2;

  while (cin.good())
  {
    int day, month, year;
    cin >> day >> month >> year;
    if (!cin.fail())
    {
      tracer() << "d2 = " << d2.nameOfDayOfWeek() << ", ";
      tracer() << d2.nameOfMonth() << " ";
      tracer() << d2.day() << " ";
      tracer() << d2.year() << " (";
      tracer() << d2.day() << "/";
      tracer() << d2.month() << "/";
      tracer() << d2.year() << ")";
      tracer() << endl;

      OTC_Date d1(day,month,year);

      tracer() << "d1 (ISO) = " << d1.asString() << endl;
      tracer() << "d1 (ISO) = " << d1 << endl;
      tracer() << "d1 = " << d1.nameOfDayOfWeek() << ", ";
      tracer() << d1.nameOfMonth() << " ";
      tracer() << d1.day() << " ";
      tracer() << d1.year() << " (";
      tracer() << d1.day() << "/";
      tracer() << d1.month() << "/";
      tracer() << d1.year() << ")";
      tracer() << endl;

      OTC_Duration d3 = d1 - d2;

      tracer() << "d3.sign() - " << d3.sign() << endl;
      tracer() << "d3.days() - " << d3.days() << endl;
      tracer() << "d3.hours() - " << d3.hours() << endl;
      tracer() << "d3.minutes() - " << d3.minutes() << endl;
      tracer() << "d3.seconds() - " << d3.seconds() << endl;

      d2 = d1;
    }
  }
}

void test4()
{
  OTC_Tracer tracer("test4");

  while (cin.good())
  {
    OTC_String theDateString = OTC_String::getline(cin);
    if (!cin.fail())
    {
      if (OTC_Date::isValidDate(theDateString))
      {
	tracer() << "okay - ";
	OTC_Date theDate(theDateString);
	tracer() << theDate << endl; 
      }
      else
      {
	tracer() << "bad format" << endl;
      }
    }
  }
}

/* ------------------------------------------------------------------------- */

typedef void (*testFunc)();

testFunc tests[] =
{
  test1,
  test2,
  test3,
  test4
};

/* ------------------------------------------------------------------------- */

void testTerminate()
{
  exit(-1);
}

main(int argc, char* argv[])
{
  u_int const numTests = sizeof(tests)/sizeof(tests[0]);

  set_terminate(testTerminate);

  if (argc != 2)
  {
    cout << numTests << endl;
    return 1;
  }
  else
  {
    int testNum = atoi(argv[1]);
    if (testNum > 0 && u_int(testNum) <= numTests)
    {
      tests[testNum-1]();
      return 0;
    }
    else
      return 1;
  }
}

/* ------------------------------------------------------------------------- */
