/*
// ============================================================================
//
// = LIBRARY
//     OUX
// 
// = FILENAME
//     dispatch/_dispatch.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 OTC LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OUX/dispatch/jobqueue.hh>
#include <OUX/dispatch/signal.hh>
#include <OTC/dispatch/dispatch.hh>
#include <OTC/dispatch/timeout.hh>
#include <OTC/dispatch/alarm.hh>
#include <OTC/dispatch/evagent.hh>
#include <OTC/dispatch/ioevent.hh>
#include <OTC/dispatch/action.hh>

#include <OUX/program/program.hh>
#include <OTC/debug/tracer.hh>
#include <OTC/debug/logstrm.hh>

#if defined(HAVE_UNISTD_H)
#include <unistd.h>
#endif
#include <stdlib.h>
#include <signal.h>
#include <time.h>

#ifdef _MSC_VER
#include <io.h>
#endif

/* ------------------------------------------------------------------------- */

class IdleJob : public OTC_Job
{
  public:

			IdleJob(int theOptions)
			  : _type(theOptions)  {}

    void		execute();


  private:

    int			_type;
};

void IdleJob::execute()
{
  OTC_Tracer tracer("IdleJob::execute()");

  tracer() << "type = " << _type << endl;
}

class Agent1 : public OTC_EVAgent
{
  public:

			Agent1()
			  : myCount(0)
				{}

  protected:

    void		handle(OTC_Event* theEvent);

  private:

    int			myCount;
};

void Agent1::handle(OTC_Event* theEvent)
{
  OTC_Tracer tracer("Agent1::handle()");
  tracer() << *theEvent << endl;

  static int count = 0;

  if (theEvent->type() == OTCEV_Alarm::typeId())
  {
    tracer() << count << endl;
    count = 0;
    OTCEV_Alarm::set(id(),time(0)+20);
    OTCEV_Timeout::start(id(),1000);
    OTCEV_Timeout::start(id(),2000);
  }
  else if (theEvent->type() == OUXEV_Signal::typeId())
  {
    OUXEV_Signal* theSignal = (OUXEV_Signal*)theEvent;

    static int theCount = 0;

    if (theSignal->signal() == SIGINT)
    {
      theCount++;
      if (theCount == 3)
        exit(1);
    }

    IdleJob* idleJob;
    idleJob = new IdleJob(OUXLIB_IDLE_JOB);
    OTC_Dispatcher::schedule(idleJob,OUXLIB_IDLE_JOB);
    idleJob = new IdleJob(OUXLIB_PRIORITY_JOB);
    OTC_Dispatcher::schedule(idleJob,OUXLIB_PRIORITY_JOB);

    OTCEV_Action::schedule(id());
    OTCEV_Action::schedule(id());
  }
  else if (theEvent->type() == OTCEV_Action::typeId())
  {
    OTCEV_Action* theAction = (OTCEV_Action*)theEvent;
    OTCEV_Action::cancel(theAction->action()+1);
  }
  else if (theEvent->type() == OTCEV_Timeout::typeId())
  {
    count++;
  }
  else if (theEvent->type() == OTCEV_IOEvent::typeId())
  {
    char buf[1];
    read(0,buf,1);
    tracer() << "char = " << buf[0] << endl;
  }

  theEvent->destroy();
}

main(int argc, char* argv[])
{
  set_terminate(otclib_terminate_function);

  OUX_Program::initialise(argc,argv);

  OTC_Tracer tracer("main()");

  Agent1 agent;

  OUX_JobQueue* queue = new OUX_JobQueue;
  OTCLIB_ASSERT(queue != 0);

  OTC_Dispatcher::initialise(queue);

  OTCEV_IOEvent::subscribe(agent.id(),0,OTCLIB_POLLIN);

  OUXEV_Signal::capacity(4);

#ifdef SIGUSR1
  OUXEV_Signal::subscribe(agent.id(),SIGUSR1);
  OUXEV_Signal::subscribe(-1,SIGUSR1);
#endif
#ifdef SIGUSR2
  OUXEV_Signal::subscribe(agent.id(),SIGUSR2);
  OUXEV_Signal::subscribe(-1,SIGUSR2);
#endif
  OUXEV_Signal::subscribe(agent.id(),SIGINT);

  long theTime = time(0);
  OTCEV_Alarm::set(agent.id(),theTime+2);
  OTCEV_Alarm::set(agent.id(),theTime+3);
  OTCEV_Alarm::set(agent.id(),theTime+3);
  OTCEV_Alarm::set(agent.id(),theTime+2);

  IdleJob* idleJob = new IdleJob(OUXLIB_IDLE_JOB);
  OTC_Dispatcher::schedule(idleJob);

  OTC_Dispatcher::run();

  return 0;
}

/* ------------------------------------------------------------------------- */
