/*
// ============================================================================
//
// = LIBRARY
//     OUX
// 
// = FILENAME
//     dispatch/_signal.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 OTC LIMITED
//
// ============================================================================
*/

#include <OUX/dispatch/signal.hh>
#include <OTC/dispatch/evagent.hh>
#include <OTC/dispatch/jobqueue.hh>

#include <OUX/program/program.hh>
#include <OTC/debug/tracer.hh>
#include <OTC/debug/logstrm.hh>

#include <stdlib.h>
#include <signal.h>
#if defined(HAVE_UNISTD_H)
#include <unistd.h>
#endif

#ifdef _MSC_VER
#include <windows.h>
inline void sleep(int period) { Sleep(period*1000); }
#endif

/* ------------------------------------------------------------------------- */

class Agent1 : public OTC_EVAgent
{
  public:

			Agent1()
			  : myCount(0)
				{}

  protected:

    void		handle(OTC_Event* theEvent);

  private:

    int			myCount;
};

void Agent1::handle(OTC_Event* theEvent)
{
  OTC_Tracer tracer("Agent1::handle()");

  ostream& outs = tracer();
  theEvent->dump(outs);
  outs << endl;
  theEvent->destroy();
}

main(int argc, char* argv[])
{
  set_terminate(otclib_terminate_function);

  OUX_Program::initialise(argc,argv);

  OTC_Tracer tracer("main()");

  Agent1 agent;

  OUXEV_Signal::capacity(4);

  OUXEV_Signal::subscribe(agent.id(),SIGINT);
#ifdef SIGUSR1
  OUXEV_Signal::subscribe(agent.id(),SIGUSR1);
#endif
#ifdef SIGUSR2
  OUXEV_Signal::subscribe(agent.id(),SIGUSR2);
#endif

  OUXEV_Signal::unsubscribeAgent(agent.id());

  OUXEV_Signal::subscribe(agent.id(),SIGINT);
#ifdef SIGUSR1
  OUXEV_Signal::subscribe(agent.id(),SIGUSR1);
#endif
#ifdef SIGUSR2
  OUXEV_Signal::subscribe(agent.id(),SIGUSR2);
#endif

  while (1)
  {
    tracer() << "sleeping" << endl;

    sleep(2);

    tracer() << "look for new jobs" << endl;

    OTC_Job* job;
    job = OUXEV_Signal::pending();

    if (job != 0)
    {
      tracer() << "execute job" << endl;

      job->execute();
      delete job;
    }
  }

  return 0;
}

/* ------------------------------------------------------------------------- */
