/*
// ============================================================================
//
// = LIBRARY
//     OUX
//
// = FILENAME
//     system/_group.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 OTC LIMITED
//
// ============================================================================
*/

#include <OUX/system/group.hh>
#include <OTC/collctn/set.hh>
#include <OTC/collctn/list.hh>
#include <OTC/debug/tracer.hh>

#include <stdlib.h>

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
OSE_TEMPLATE OTC_Set<OUX_Group>
OSE_TEMPLATE OTC_List<gid_t>
#endif

void test1()
{
  OTC_Tracer tracer("test1()");
  OTC_List<gid_t> gids;
  OTC_Set<OUX_Group> groups;
  group* grent = getgrent();
  while (grent != 0)
  {
    gid_t gid = grent->gr_gid;
    gids.addLast(gid);
    grent = getgrent();
  }
  OTC_Iterator<gid_t> iter1(gids.items());
  for (iter1.reset(); iter1.isValid(); iter1.next())
  {
    OUX_Group group(iter1.item());
    if (groups.contains(group))
      tracer() << "DUPLICATE: " << group.gid() << " - " << group.name() << endl;
    else
      groups.add(group);
  }
  OTC_Iterator<OUX_Group> iter2(groups.items());
  for (iter2.reset(); iter2.isValid(); iter2.next())
  {
    OUX_Group const& group = iter2.item();
    tracer() << group.gid() << " - " << group.name() << endl;
  }
}

void test2()
{
  OTC_Tracer tracer("test2()");
  OTC_Set<OUX_Group> groups;
  OUX_Group group = getgrent();
  while (group.isValid())
  {
    if (groups.contains(group))
      tracer() << "DUPLICATE: " << group.gid() << " - " << group.name() << endl;
    else
      groups.add(group);
    group = getgrent();
  }
  OTC_Iterator<OUX_Group> iter2(groups.items());
  for (iter2.reset(); iter2.isValid(); iter2.next())
  {
    OUX_Group const& group = iter2.item();
    tracer() << group.gid() << " - " << group.name() << endl;
  }
}

typedef void (*testFunc)();

testFunc tests[] =
{
  test1,
  test2
};

/* ------------------------------------------------------------------------- */

main(int argc, char* argv[])
{
  u_int const numTests = sizeof(tests)/sizeof(tests[0]);

  set_terminate(otclib_terminate_function);

  if (argc != 2)
  {
    cout << numTests << endl;
    return 1;
  }
  else
  {
    int testNum = atoi(argv[1]);
    if (testNum > 0 && u_int(testNum) <= numTests)
    {
      tests[testNum-1]();
      return 0;
    }
    else
      return 1;
  }
}

/* ------------------------------------------------------------------------- */
