/*
// ============================================================================
//
// = LIBRARY
//     OUX
//
// = FILENAME
//     system/_user.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 OTC LIMITED
//
// ============================================================================
*/

#include <OUX/system/user.hh>
#include <OTC/collctn/set.hh>
#include <OTC/collctn/list.hh>
#include <OTC/debug/tracer.hh>

#include <stdlib.h>

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
OSE_TEMPLATE OTC_Set<OUX_User>
OSE_TEMPLATE OTC_List<uid_t>
#endif

void test1()
{
  OTC_Tracer tracer("test1()");
  OTC_List<uid_t> uids;
  OTC_Set<OUX_User> users;
  passwd* pwent = getpwent();
  while (pwent != 0)
  {
    uid_t uid = pwent->pw_uid;
    uids.addLast(uid);
    pwent = getpwent();
  }
  OTC_Iterator<uid_t> iter1(uids.items());
  for (iter1.reset(); iter1.isValid(); iter1.next())
  {
    OUX_User user(iter1.item());
    if (users.contains(user))
      tracer() << "DUPLICATE: " << user.uid() << " - " << user.name() << endl;
    else
      users.add(user);
  }
  OTC_Iterator<OUX_User> iter2(users.items());
  for (iter2.reset(); iter2.isValid(); iter2.next())
  {
    OUX_User const& user = iter2.item();
    tracer() << user.uid() << " - " << user.fullname() << endl;
  }
}

void test2()
{
  OTC_Tracer tracer("test2()");
  OTC_List<uid_t> uids;
  OTC_Set<OUX_User> users;
  OUX_User user = getpwent();
  while (user.isValid())
  {
    if (users.contains(user))
      tracer() << "DUPLICATE: " << user.uid() << " - " << user.name() << endl;
    else
      users.add(user);
    user = getpwent();
  }
  OTC_Iterator<OUX_User> iter2(users.items());
  for (iter2.reset(); iter2.isValid(); iter2.next())
  {
    OUX_User const& user = iter2.item();
    tracer() << user.uid() << " - " << user.fullname() << endl;
  }
}

typedef void (*testFunc)();

testFunc tests[] =
{
  test1,
  test2
};

/* ------------------------------------------------------------------------- */

main(int argc, char* argv[])
{
  u_int const numTests = sizeof(tests)/sizeof(tests[0]);

  set_terminate(otclib_terminate_function);

  if (argc != 2)
  {
    cout << numTests << endl;
    return 1;
  }
  else
  {
    int testNum = atoi(argv[1]);
    if (testNum > 0 && u_int(testNum) <= numTests)
    {
      tests[testNum-1]();
      return 0;
    }
    else
      return 1;
  }
}

/* ------------------------------------------------------------------------- */
