/*
// ============================================================================
//
// = LIBRARY
//     OUX
//
// = FILENAME
//     system/ouxgroup.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
//
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//
// = NOTES
//     DEC C++ has prototype for <getgrnam()> which takes <char*> instead
//     of <char const*>. Thus forcibly cast to <char*> when calling this
//     function.
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OUX/system/group.hh"
#endif

#include <OUX/system/group.hh>

#include <strstream.h>
#include <unistd.h>
#if defined(CXX_ATT2_1) || defined(CXX_CL1_1)
#include <osfcn.h>
#endif

#if defined(ENV_OSTORE)
/* ------------------------------------------------------------------------- */
os_typespec* OUX_Group::typespec()
{
  static os_typespec ts("OUX_Group");
  return &ts;
}
#endif

/* ------------------------------------------------------------------------- */
void OUX_Group::init(group const* theGrent)
{
  if (theGrent != 0)
  {
    myValid = OTCLIB_TRUE;
    myGID = theGrent->gr_gid;
    myName = theGrent->gr_name;
    char** theMembers;
    if ((theMembers = theGrent->gr_mem) != 0)
    {
      while (*theMembers != 0)
	myMembers.add(*theMembers++);
    }
  }
  else
    myValid = OTCLIB_FALSE;
}

/* ------------------------------------------------------------------------- */
OUX_Group::OUX_Group()
{
  gid_t theGID = getegid();
  init(getgrgid(theGID));
  if (!isValid())
  {
    myGID = theGID;
    strstream ss;
    ss << gid();
    ss >> myName;
  }
}

/* ------------------------------------------------------------------------- */
OUX_Group::OUX_Group(gid_t theGID)
{
  init(getgrgid(theGID));
  if (!isValid())
  {
    myGID = theGID;
    strstream ss;
    ss << gid();
    ss >> myName;
  }
}

/* ------------------------------------------------------------------------- */
OUX_Group::OUX_Group(group const* theGrent)
{
  init(theGrent);
  if (!isValid())
  {
    myGID = 65534;
    strstream ss;
    ss << gid();
    ss >> myName;
  }
}

/* ------------------------------------------------------------------------- */
OUX_Group::OUX_Group(OTC_String const& theName)
{
  init(getgrnam((char*)theName.string()));
  if (!isValid())
  {
    myGID = 65534;
    myName = theName;
  }
}

/* ------------------------------------------------------------------------- */
OUX_Group::OUX_Group(OUX_Group const& theGroup)
  : myValid(theGroup.isValid()),
    myName(theGroup.name()),
    myGID(theGroup.gid()),
    myMembers(theGroup.myMembers)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
OUX_Group& OUX_Group::operator=(OUX_Group const& theGroup)
{
  myValid = theGroup.isValid();
  myGID = theGroup.gid();
  myName = theGroup.name();
  myMembers = theGroup.myMembers;
  return *this;
}

/* ------------------------------------------------------------------------- */
OUX_Group& OUX_Group::operator=(group const* theGrent)
{
  myMembers.removeAll();
  init(theGrent);
  if (!isValid())
  {
    myGID = 65534;
    strstream ss;
    ss << gid();
    ss >> myName;
  }
  return *this;
}

#if defined(CXX_OS)
/* ------------------------------------------------------------------------- */
int OTC_RankActions<OUX_Group>::rank(
 OUX_Group const& theGrp1,
 OUX_Group const& theGrp2
)
{
  return theGrp1.gid() - theGrp2.gid();
}

/* ------------------------------------------------------------------------- */
int OTC_HashActions<OUX_Group>::hash(OUX_Group const& theGrp)
{
  return theGrp.gid();
}
#endif

/* ------------------------------------------------------------------------- */
