/*
// ============================================================================
//
// = LIBRARY
//     OUX
// 
// = FILENAME
//     system/ouxsigblock.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 OTC LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OUX/system/sigblock.hh"
#endif

#include <OUX/system/sigblock.hh>

#if defined(HAVE_UNISTD_H)
#include <unistd.h>
#endif
#include <stdlib.h>
#if defined(CXX_ATT2_1) || defined(CXX_CL1_1)
#include <osfcn.h>
#endif

#if defined(HAVE_SIGPROCMASK)
#if defined(sun)
  // Sun platform.
#if defined(HAVE_SYS_RESOURCE_H) && !defined(HAVE_SYS_ELF_H)
  // SunOS 4.1.X
#if !defined(CXX_SUN) && !defined(CXX_CL2_1)
  // Non Sun / Non CenterLine 2.1 compiler.
  extern "C" int sigprocmask(int, sigset_t const*, sigset_t*);
#endif
#endif
#else
  // Non Sun platform.
#if !defined(M_XENIX) && !defined(__linux__)
  // Non SCO/LINUX platform.
  extern "C" int sigprocmask(int, sigset_t const*, sigset_t*);
#endif
#endif
#ifndef sigemptyset
extern "C" int sigemptyset(sigset_t*);
#endif
#ifndef sigfillset
extern "C" int sigfillset(sigset_t*);
#endif
#ifndef sigaddset
extern "C" int sigaddset(sigset_t*, int);
#endif
#ifndef sigdelset
extern "C" int sigdelset(sigset_t*, int);
#endif
#endif

/* ------------------------------------------------------------------------- */
OUX_SignalBlock::OUX_SignalBlock(int theSignal)
  : mySignal(theSignal)
{
  if (mySignal == 0)
    return;

#ifndef _MSC_VER
#if defined(HAVE_SIGPROCMASK)
  sigset_t theNewMask;
  if (theSignal == -1)
  {
    sigfillset(&theNewMask);
    sigdelset(&theNewMask,SIGABRT);
  }
  else
  {
    sigemptyset(&theNewMask);
    sigaddset(&theNewMask,theSignal);
  }

  sigprocmask(SIG_BLOCK,&theNewMask,&myOldMask);
#else
  int theNewMask = 0;
  if (theSignal == -1)
  {
    theNewMask = sigmask(SIGABRT);
    theNewMask ^= ~0;
  }
  else
    theNewMask = sigmask(theSignal);

  myOldMask = sigblock(theNewMask);
#endif
#endif
}

/* ------------------------------------------------------------------------- */
void OUX_SignalBlock::release()
{
  if (mySignal == 0)
    return;

#ifndef _MSC_VER
#if defined(HAVE_SIGPROCMASK)
  sigprocmask(SIG_SETMASK,&myOldMask,0);
#else
  sigsetmask(myOldMask);
#endif
#endif

  mySignal = 0;
}

/* ------------------------------------------------------------------------- */
