/*
// ============================================================================
//
// = LIBRARY
//     OUX
// 
// = FILENAME
//     system/ouxsighndle.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OUX/system/sighndle.hh"
#endif

#include <OUX/system/sighndle.hh>

#include <stdlib.h>
#include <string.h>

#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif

#include <signal.h>
#if defined(HAVE_UNISTD_H)
#include <unistd.h>
#endif
#if defined(CXX_ATT2_1) || defined(CXX_CL1_1)
#include <osfcn.h>
#endif

#ifdef HAVE_SIGACTION

#if !defined(CXX_CL) && !defined(M_XENIX) && !defined(CXX_ATT2_1) && \
    !defined(CXX_OS) && !defined(__linux__) && \
    !((defined(CXX_SUN) || defined(CXX_LC)) && !defined(HAVE_SYS_ELF_H))
extern "C" int sigaction(int, struct sigaction const*, struct sigaction*);
#endif

#if (defined(CXX_CL) && (defined(CXX_CL1_0) || defined(CXX_CL1_1) || \
    defined(CXX_CL2_0_0) || defined(CXX_CL2_0_1) || \
    defined(CXX_CL2_0_2) || defined(CXX_CL2_0_3)))
extern "C" int sigaction(int, struct sigaction const*, struct sigaction*);
#endif

#ifndef sigemptyset
extern "C" int sigemptyset(sigset_t*);
#endif
#ifndef sigfillset
extern "C" int sigfillset(sigset_t*);
#endif
#ifndef sigaddset
extern "C" int sigaddset(sigset_t*, int);
#endif
#ifndef sigdelset
extern "C" int sigdelset(sigset_t*, int);
#endif
#endif

#ifdef NEED_MEMSET
extern "C" void* memset(void*, int, int);
#endif

/* ------------------------------------------------------------------------- */
OUX_SignalFunction OUX_SignalHandler::install(
 int theSignal,
 OUX_SignalFunction theFunc
)
{
  // <0> usually indicates default signal handler, but do this
  // just to make sure.

  if (theFunc == 0)
    theFunc = (OUX_SignalFunction)SIG_DFL;

#ifdef HAVE_SIGACTION
  struct sigaction act;
  struct sigaction oact;
  memset(&act,0,sizeof(struct sigaction));
  memset(&oact,0,sizeof(struct sigaction));

#if defined(CXX_SUN)
#if defined(HAVE_SYS_RESOURCE_H) && !defined(HAVE_SYS_ELF_H)
  // Sun C++ - SunOS 4.1.X / Sun C++ 2.1 / Sun C++ 3.0.X
#if defined(CXX_SUN2_1) || defined(CXX_SUN3_0)
  act.sa_handler = (void (*)(DOTDOTDOT))theFunc;
#else
  act.sa_handler = (void (*)(int,DOTDOTDOT))theFunc;
#endif
#else
  // Sun C++ - SunOS 5.X
  act.sa_handler = (void (*)())theFunc;
#endif
#else
#if defined(M_XENIX)
  // SCO UNIX
#ifdef __STDC__
  act.sa_handler = (void (*)(int))theFunc;
#else
  act.sa_handler = __SIG_FTN theFunc;
#endif
#else
#if defined(__nonstopux)
  // Tandem Non Stop UNIX
  act.sa_handler = (void (*)_EXTERN_ARGS((int)))theFunc;
#else
#if defined(hpux)
  act.sa_handler = (void (*)(__harg))theFunc;
#else
#if defined(CXX_LC)
  act.sa_handler = (void (*)_LUCID_SIGARGLIST)theFunc;
#else
#if defined(__linux__) || defined(_AIX) || defined(__osf__)
  act.sa_handler = (void (*)(int))theFunc;
#else
#if defined(__sgi)
  act.sa_handler = (__sigret_t (*)(_sigargs))theFunc;
#else
#if defined(CXX_CL) && \
    !defined(CXX_CL1_0) && !defined(CXX_CL1_1) && \
    !defined(CXX_CL2_0_0) && !defined(CXX_CL2_0_1) && \
    !defined(CXX_CL2_0_2) && !defined(CXX_CL2_0_3)
#if defined(HAVE_SYS_RESOURCE_H) && !defined(HAVE_SYS_ELF_H)
  act.sa_handler = (SIG_PF)theFunc;
#else
  act.sa_handler = (void (*)())theFunc;
#endif
#else
#ifdef ENV_VXWORKS
  act.sa_handler = (void (*)(int))theFunc;
#else
  act.sa_handler = (void (*)())theFunc;
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif

  sigemptyset(&act.sa_mask);
  act.sa_flags = 0;
  sigaction(theSignal,(struct sigaction*)&act,(struct sigaction*)&oact);
  return (OUX_SignalFunction)oact.sa_handler;
#else
#if defined(__GNUG__)
  return (OUX_SignalFunction)::signal(theSignal,theFunc);
#else
#ifdef _MSC_VER
  return (OUX_SignalFunction)::signal(theSignal,theFunc);
#else
  return (OUX_SignalFunction)::signal(theSignal,(void (__cdecl*)(int))theFunc);
#endif
#endif
#endif
}

/* ------------------------------------------------------------------------- */
