/*
// ============================================================================
//
// = LIBRARY
//     OUX
//
// = FILENAME
//     system/ouxuser.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
//
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//
// = NOTES
//     DEC C++ has prototype for <getpwnam()> which takes <char*> instead
//     of <char const*>. Thus forcibly cast to <char*> when calling this
//     function.
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OUX/system/user.hh"
#endif

#include <OUX/system/user.hh>

#include <strstream.h>
#include <unistd.h>
#if defined(CXX_ATT2_1) || defined(CXX_CL1_1)
#include <osfcn.h>
#endif

#if defined(ENV_OSTORE)
/* ------------------------------------------------------------------------- */
os_typespec* OUX_User::typespec()
{
  static os_typespec ts("OUX_User");
  return &ts;
}
#endif

/* ------------------------------------------------------------------------- */
void OUX_User::init(passwd const* thePwent)
{
  if (thePwent != 0)
  {
    myValid = OTCLIB_TRUE;
    myName = thePwent->pw_name;
    myUID = thePwent->pw_uid;
    myGID = thePwent->pw_gid;
    OTC_Record theGecos(thePwent->pw_gecos,',');
    if (theGecos.numFields() >= 1)
      myFullname = theGecos[1];
  }
  else
    myValid = OTCLIB_FALSE;
}

/* ------------------------------------------------------------------------- */
OUX_User::OUX_User()
{
  uid_t theUID = geteuid();
  init(getpwuid(theUID));
  if (!isValid())
  {
    myUID = theUID;
    myGID = theUID;
    strstream ss;
    ss << uid();
    ss >> myName;
  }
}

/* ------------------------------------------------------------------------- */
OUX_User::OUX_User(uid_t theUID)
{
  init(getpwuid(theUID));
  if (!isValid())
  {
    myUID = theUID;
    myGID = theUID;
    strstream ss;
    ss << uid();
    ss >> myName;
  }
}

/* ------------------------------------------------------------------------- */
OUX_User::OUX_User(OTC_String const& theName)
{
  init(getpwnam((char*)theName.string()));
  if (!isValid())
  {
    myUID = 65534;
    myGID = 65534;
    myName = theName;
  }
}

/* ------------------------------------------------------------------------- */
OUX_User::OUX_User(passwd const* thePwent)
{
  init(thePwent);
  if (!isValid())
  {
    myUID = 65534;
    myGID = 65534;
    strstream ss;
    ss << uid();
    ss >> myName;
  }
}

/* ------------------------------------------------------------------------- */
OUX_User::OUX_User(OUX_User const& theUser)
  : myValid(theUser.isValid()),
    myName(theUser.name()),
    myFullname(theUser.fullname()),
    myUID(theUser.uid()),
    myGID(theUser.gid())
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
OUX_User& OUX_User::operator=(OUX_User const& theUser)
{
  myValid = theUser.isValid();
  myUID = theUser.uid();
  myGID = theUser.gid();
  myName = theUser.name();
  myFullname = theUser.fullname();
  return *this;
}

/* ------------------------------------------------------------------------- */
OUX_User& OUX_User::operator=(passwd const* thePwent)
{
  init(thePwent);
  if (!isValid())
  {
    myUID = 65534;
    myGID = 65534;
    strstream ss;
    ss << uid();
    ss >> myName;
    myFullname = "";
  }
  return *this;
}

#if defined(CXX_OS)
/* ------------------------------------------------------------------------- */
int OTC_RankActions<OUX_User>::rank(
 OUX_User const& theUser1,
 OUX_User const& theUser2
)
{
  return theUser1.uid() - theUser2.uid();
}

/* ------------------------------------------------------------------------- */
int OTC_HashActions<OUX_User>::hash(OUX_User const& theUser)
{
  return theUser.uid();
}
#endif

/* ------------------------------------------------------------------------- */
