## Copyright 1992 OTC LIMITED
## Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED

all :

makeit.setup ::

## Mark that we are building OSE.

OSE_BUILD := YES

override PROJECT_CPPFLAGS += -DOSE_BUILD

## Set MKTAG now to allow it to be used below. Make sure "=" and not ":="
## is used. Also null out MKPREFIX so it doesn't give us problems.

MKTAG = $(OSE_HOST)

override MKPREFIX :=
override MKSUFFIX :=

## Location of makeit files.

OSE_MAKEIT := $(SRCROOT)/include/makeit
OSE_HOST_MAKEIT := $(SRCROOT)/host/$(OSE_HOST)

## Location of template preprocessor and other stuff for when we are
## building everything.

CPPDIR = $(BLDROOT)/util/cpp/$(WSPREFIX)$(MKTAG)_std
SCRIPTDIR = $(BLDROOT)/util/scripts/$(WSPREFIX)$(MKTAG)_std

## Force cleaning of all temporary files even though they
## may not ever be generated during a particular build.

_makeit_cleanup_pure := YES
_makeit_cleanup_objectstore := YES
_makeit_cleanup_sentinel := YES
_makeit_cleanup_testcenter := YES

## Dependency to avoid complaints about not be able to generate the header
## file <strstream.h> for platforms that do not require it. At the same time
## we ensure that we remove any dependency on the file.

override DEPFILTER := sed -e "/ \/.*/d" -e "/host.*strstream/d"

$(OSE_HOST_MAKEIT)/strstream.h :

## Include normal initialisation stuff.

include $(OSE_MAKEIT)/init.mk

## Use our own "install" script when doing installation.
## We need to run it explicitly using the shell as we
## cannot just run it by itself on Windows NT.

override INSTALL := $(SHELL) $(SRCROOT)/install.sh -c

## Versant flags.

ifeq "$(C++COMPILERENV)" "VERSANT"
ifneq "$(filter VERSANT-%,$(C++COMPILERTAG))" ""
override PROJECT_C++FLAGS += -noschema
endif
endif

## Lucid C++ flags.

ifneq "$(filter LC%,$(C++COMPILER))" ""
# override PROJECT_C++FLAGS += -Xpte:hh:c
ifeq "$(filter combine,$(MODULES))" ""
override PROJECT_C++FLAGS += -Xpt-
endif
endif

## Sun C++ 4.0 workaround.

ifneq "$(filter SUN4.0%,$(C++COMPILER))" ""
override MAKEIT_OPTIONS += minimal_expansion
endif

## KAI C++. Avoid template instantiation for shared libraries.

# ifneq "$(filter KAI%,$(C++COMPILER))" ""
# INTERNAL_C++PICFLAGS += --no_auto_instantiation
# endif
