/*


 Copyright (C) 1990 Texas Instruments Incorporated.

 Permission is granted to any individual or institution to use, copy, modify,
 and distribute this software, provided that this complete copyright and
 permission notice is maintained, intact, in all copies and supporting
 documentation.

 Texas Instruments Incorporated provides this software "as is" without
 express or implied warranty.

*/

#pragma defmacro MACRO "macro" delimiter=}


//
// Example 1
//

MACRO set_val (size, value=0, KEY: low = 0, high = 100) {
 set_val_internal(size, value, low, high-low)
}

set_val(5)
set_val(foo, 2, low=5)
set_val(bar, baz, high=95)


//
// Example 2
//

MACRO build_table (name, REST: rest) {
 char* name[] = { build_table_internal(rest) NULL }
}

MACRO build_table_internal (first, REST: rest=count) {
 #first,
 #if count
 build_table_internal(rest)
 #endif
}

build_table(table, 1, 2, 3, 4, 5, 6, 7);


//
// Example 3
//

MACRO LOOP (type, variable, sequence, BODY: body) {
 { type variable;
   for (sequence.reset; sequence.next;)
       { variable = sequence.value();
         body
       }
 }
}

LOOP (char, elt, list) { print(elt) }
