#! @SHELL@

if test "$#" = "0"
then
  echo "OSECC: invalid arguments" 1>&2
  exit 1
fi

if test "$CPPDIR" = ""
then
  echo "OSECC: location of OSE cpp not defined" 1>&2
  exit 1
fi

FLAGS=
FILES=
CFILES=
INCL=
CFLAG=
CPP=

COMPILER=$1
shift

while test "$#" != 0
do
  case "$1" in
    -E)
      CPP="1";
      FLAGS="$FLAGS $1";
      ;;
    -I*)
      INCL="$INCL $1";
      FLAGS="$FLAGS $1";
      ;;
    -c)
      CFLAG="-c";
      ;;
    [-+]*)
      FLAGS="$FLAGS $1";
      ;;
    *.c|*.cc|*.cxx|*.C)
      FILES="$FILES $1";
      ;;
    *)
      FLAGS="$FLAGS $1";
      ;;
  esac
  shift
done

TMPDIR=${TMPDIR-/usr/tmp}
TEMPDIR=$TMPDIR/OSECC.$$

rm -fr $TEMPDIR
trap 'rm -fr $TEMPDIR; exit' 1 2 3 13 15
mkdir $TEMPDIR

if test "$FILES" != ""
then
  for i in $FILES
  do
    case $i in
      *.c)
	CFILE="$TEMPDIR/`basename $i .c`.cc"
	IFILE="$TEMPDIR/`basename $i .c`.i"
	;;
      *.cc)
	CFILE="$TEMPDIR/`basename $i .cc`.cc"
	IFILE="$TEMPDIR/`basename $i .cc`.i"
	;;
      *.cxx)
	CFILE="$TEMPDIR/`basename $i .cxx`.cc"
	IFILE="$TEMPDIR/`basename $i .cxx`.i"
	;;
      *.C)
	CFILE="$TEMPDIR/`basename $i .C`.cc"
	IFILE="$TEMPDIR/`basename $i .C`.i"
	;;
    esac
    CFILES="$CFILES $CFILE"
    if test "$CPP" = ""
    then
      echo "$COMPILER -E -D__OSE_TEMPLATES__ $i $FLAGS | $CPPDIR/cpp > $CFILE"
    fi
    echo "# 1 \"$i\"" > $IFILE
    echo "#include <OTC/ansi/template.hh>" >> $IFILE
    $COMPILER -E -D__OSE_TEMPLATES__ $i $FLAGS >> $IFILE
    cat $IFILE | $CPPDIR/cpp -C $INCL | \
     sed -e 's/^#pragma interface.*//' \
     -e 's/^#pragma implementation.*//' > $CFILE
    E=$?
    if test $E -ne 0
    then
      rm -fr $TEMPDIR
      exit 1
    fi
  done
  if test "$CPP" = ""
  then
    echo "$COMPILER $CFILES $CFLAG $FLAGS"
  fi
  $COMPILER $CFILES $CFLAG $FLAGS
  E=$?
  if test $E -ne 0
  then
    rm -fr $TEMPDIR
    exit 1
  fi
else
  echo "$COMPILER $CFLAG $FLAGS"
  $COMPILER $CFLAG $FLAGS
  E=$?
  if test $E -ne 0
  then
    rm -fr $TEMPDIR
    exit 1
  fi
fi

rm -fr $TEMPDIR
