/*
 * $XConsortium: Xos.h,v 1.24 89/12/18 16:14:23 rws Exp $
 * 
 * Copyright 1987 by the Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided 
 * that the above copyright notice appear in all copies and that both that 
 * copyright notice and this permission notice appear in supporting 
 * documentation, and that the name of M.I.T. not be used in advertising
 * or publicity pertaining to distribution of the software without specific, 
 * written prior permission. M.I.T. makes no representations about the 
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * The X Window System is a Trademark of MIT.
 *
 */

/* This is a collection of things to try and minimize system dependencies
 * in a "signficant" number of source files.
 */

#ifndef _XOS_H_
#define _XOS_H_

#ifdef MSDOS /* POHC 90/10/08 */
#define SYSV
#endif /* MSDOS */

/*
 * Get major data types (esp. caddr_t)
 */

#ifdef USG
#ifndef __TYPES__
#ifdef CRAY
#define word word_t
#endif
#include <sys/types.h>			/* forgot to protect it... */
#define __TYPES__
#ifdef CRAY
#undef word
#endif
#endif /* __TYPES__ */
#else
#include <sys/types.h>
#endif /* USG */

#ifndef _CADDR_T_DEF_
#ifndef __NDPC__
#ifndef caddr_t /* POHC 91/01/25 */
typedef char *		caddr_t;
#define _CADDR_T_DEF_   /* MJCR/POHC 91/03/01 */
#endif
#endif
#endif

/*
 * Just about everyone needs the strings routines.  For uniformity, we use
 * the BSD-style index() and rindex() in application code, so any systems that
 * don't provide them need to have #defines here.  Unfortunately, we can't
 * use #if defined() here since makedepend will get confused.
 *
 * The list of systems that currently needs System V stings includes:
 *
 *	hpux
 * 	macII
 *	CRAY
 *	stellar
 *	USG
 *	MSDOS				POHC 90/10/05
 * 
 * all of which happen to define SYSV as well.
 */

#ifdef SYSV
#include <string.h>
#define index strchr
#define rindex strrchr
#else
#include <strings.h>
#endif /* SYSV */


/*
 * Get open(2) constants
 */
#ifdef SYSV
#ifndef macII
#include <fcntl.h>
#endif
#endif /* SYSV */
#ifndef MSDOS /* POHC 91/01/28 */ 
#include <sys/file.h>
#endif /* MSDOS */
#ifdef USG
#include <unistd.h>
#endif

#ifdef MSDOS /* 90/06/20 POHC */
#if 0 /* POHC */
#include <fcntl.h>
#endif
#ifndef F_SETFL /* POHC 91/01/16 */
/* fcntl(2) requests */
#define	F_DUPFD		0	/* Duplicate fildes */
#define	F_GETFD		1	/* Get fildes flags */
#define	F_SETFD		2	/* Set fildes flags */
#define	F_GETFL		3	/* Get file flags */
#define	F_SETFL		4	/* Set file flags */
#define	F_GETLK		5	/* Get file lock */
#define	F_SETLK		6	/* Set file lock */
#define	F_SETLKW	7	/* Set file lock and wait */
#define	F_CHKFL		8	/* reserved */
#define	F_ALLOCSP	10	/* reserved */
#define	F_FREESP	11	/* reserved */
#define F_CHSIZE	0x6000 	/* XENIX chsize() system call */	
#define F_RDCHK		0x6001	/* XENIX rdchk() system call */
#endif

#define R_OK 4 /* Test for Read permission */
#define W_OK 2 /* Test for Write permission */
#define X_OK 1 /* Test for eXecute permission */
#define F_OK 0 /* Test for existence of File */

#endif

/*
 * Get struct timeval
 */

#ifdef SYSV
#if defined(sgi) || defined(CRAY2) || defined(stellar)
#include <sys/time.h>				/* SYSV sys/time.h */
#ifdef CRAY2
#include <time.h>
#define __TIMEVAL__
#endif
#else
#include <time.h>				/* else SYSV time.h */
#endif

#if defined(USG)
#ifndef __TIMEVAL__
#define __TIMEVAL__
struct timeval {
    long tv_sec;
    long tv_usec;
};
struct timezone {
    int tz_minuteswest;
    int tz_dsttime;
};
#endif /* __TIMEVAL__ */
#endif /* USG */

#ifdef macII
#include <sys/time.h>				/* SYSV && macII */
#endif

#else
#include <sys/time.h>				/* else bsd */
#endif

#ifdef MSDOS /* POHC 92/08/19 */
#include <sys/time.h>
#include <sys/uio.h>
#endif

/*
 * More BSDisms
 */

#ifdef SYSV
#ifndef macII
#ifndef ibm
#define SIGCHLD SIGCLD
#endif
#endif
#endif


/*
 * Put system-specific definitions here
 */

#ifdef hpux
#define sigvec sigvector
#endif

#if defined(MSDOS) && !defined(__GNUC__) && !defined(__SALFORD__) /* 90/06/25 POHC */
#define bcopy(a,b,c)    memcpy(b,a,c)
#define bcmp(a,b,c)     memcmp(a,b,c)
#define bzero(a,b)      memset(a,0,b)

#ifndef index
#define index		strchr
#endif

#ifndef rindex
#define rindex		strrchr
#endif

#endif

#endif /* _XOS_H_ */
